/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.AccessTier;
import com.azure.resourcemanager.storage.models.AzureFilesIdentityBasedAuthentication;
import com.azure.resourcemanager.storage.models.CustomDomain;
import com.azure.resourcemanager.storage.models.Encryption;
import com.azure.resourcemanager.storage.models.ExtendedLocation;
import com.azure.resourcemanager.storage.models.Identity;
import com.azure.resourcemanager.storage.models.KeyPolicy;
import com.azure.resourcemanager.storage.models.Kind;
import com.azure.resourcemanager.storage.models.LargeFileSharesState;
import com.azure.resourcemanager.storage.models.MinimumTlsVersion;
import com.azure.resourcemanager.storage.models.NetworkRuleSet;
import com.azure.resourcemanager.storage.models.RoutingPreference;
import com.azure.resourcemanager.storage.models.SasPolicy;
import com.azure.resourcemanager.storage.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class StorageAccountCreateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(StorageAccountCreateParameters.class);
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="kind", required=true)
    private Kind kind;
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="identity")
    private Identity identity;
    @JsonProperty(value="properties.sasPolicy")
    private SasPolicy sasPolicy;
    @JsonProperty(value="properties.keyPolicy")
    private KeyPolicy keyPolicy;
    @JsonProperty(value="properties.customDomain")
    private CustomDomain customDomain;
    @JsonProperty(value="properties.encryption")
    private Encryption encryption;
    @JsonProperty(value="properties.networkAcls")
    private NetworkRuleSet networkRuleSet;
    @JsonProperty(value="properties.accessTier")
    private AccessTier accessTier;
    @JsonProperty(value="properties.azureFilesIdentityBasedAuthentication")
    private AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication;
    @JsonProperty(value="properties.supportsHttpsTrafficOnly")
    private Boolean enableHttpsTrafficOnly;
    @JsonProperty(value="properties.isHnsEnabled")
    private Boolean isHnsEnabled;
    @JsonProperty(value="properties.largeFileSharesState")
    private LargeFileSharesState largeFileSharesState;
    @JsonProperty(value="properties.routingPreference")
    private RoutingPreference routingPreference;
    @JsonProperty(value="properties.allowBlobPublicAccess")
    private Boolean allowBlobPublicAccess;
    @JsonProperty(value="properties.minimumTlsVersion")
    private MinimumTlsVersion minimumTlsVersion;
    @JsonProperty(value="properties.allowSharedKeyAccess")
    private Boolean allowSharedKeyAccess;
    @JsonProperty(value="properties.isNfsV3Enabled")
    private Boolean enableNfsV3;

    public Sku sku() {
        return this.sku;
    }

    public StorageAccountCreateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Kind kind() {
        return this.kind;
    }

    public StorageAccountCreateParameters withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    public String location() {
        return this.location;
    }

    public StorageAccountCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public StorageAccountCreateParameters withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public StorageAccountCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public StorageAccountCreateParameters withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public SasPolicy sasPolicy() {
        return this.sasPolicy;
    }

    public StorageAccountCreateParameters withSasPolicy(SasPolicy sasPolicy) {
        this.sasPolicy = sasPolicy;
        return this;
    }

    public KeyPolicy keyPolicy() {
        return this.keyPolicy;
    }

    public StorageAccountCreateParameters withKeyPolicy(KeyPolicy keyPolicy) {
        this.keyPolicy = keyPolicy;
        return this;
    }

    public CustomDomain customDomain() {
        return this.customDomain;
    }

    public StorageAccountCreateParameters withCustomDomain(CustomDomain customDomain) {
        this.customDomain = customDomain;
        return this;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public StorageAccountCreateParameters withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public StorageAccountCreateParameters withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    public AccessTier accessTier() {
        return this.accessTier;
    }

    public StorageAccountCreateParameters withAccessTier(AccessTier accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication() {
        return this.azureFilesIdentityBasedAuthentication;
    }

    public StorageAccountCreateParameters withAzureFilesIdentityBasedAuthentication(AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication) {
        this.azureFilesIdentityBasedAuthentication = azureFilesIdentityBasedAuthentication;
        return this;
    }

    public Boolean enableHttpsTrafficOnly() {
        return this.enableHttpsTrafficOnly;
    }

    public StorageAccountCreateParameters withEnableHttpsTrafficOnly(Boolean enableHttpsTrafficOnly) {
        this.enableHttpsTrafficOnly = enableHttpsTrafficOnly;
        return this;
    }

    public Boolean isHnsEnabled() {
        return this.isHnsEnabled;
    }

    public StorageAccountCreateParameters withIsHnsEnabled(Boolean isHnsEnabled) {
        this.isHnsEnabled = isHnsEnabled;
        return this;
    }

    public LargeFileSharesState largeFileSharesState() {
        return this.largeFileSharesState;
    }

    public StorageAccountCreateParameters withLargeFileSharesState(LargeFileSharesState largeFileSharesState) {
        this.largeFileSharesState = largeFileSharesState;
        return this;
    }

    public RoutingPreference routingPreference() {
        return this.routingPreference;
    }

    public StorageAccountCreateParameters withRoutingPreference(RoutingPreference routingPreference) {
        this.routingPreference = routingPreference;
        return this;
    }

    public Boolean allowBlobPublicAccess() {
        return this.allowBlobPublicAccess;
    }

    public StorageAccountCreateParameters withAllowBlobPublicAccess(Boolean allowBlobPublicAccess) {
        this.allowBlobPublicAccess = allowBlobPublicAccess;
        return this;
    }

    public MinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public StorageAccountCreateParameters withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public Boolean allowSharedKeyAccess() {
        return this.allowSharedKeyAccess;
    }

    public StorageAccountCreateParameters withAllowSharedKeyAccess(Boolean allowSharedKeyAccess) {
        this.allowSharedKeyAccess = allowSharedKeyAccess;
        return this;
    }

    public Boolean enableNfsV3() {
        return this.enableNfsV3;
    }

    public StorageAccountCreateParameters withEnableNfsV3(Boolean enableNfsV3) {
        this.enableNfsV3 = enableNfsV3;
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model StorageAccountCreateParameters"));
        }
        this.sku().validate();
        if (this.kind() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property kind in model StorageAccountCreateParameters"));
        }
        if (this.location() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model StorageAccountCreateParameters"));
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sasPolicy() != null) {
            this.sasPolicy().validate();
        }
        if (this.keyPolicy() != null) {
            this.keyPolicy().validate();
        }
        if (this.customDomain() != null) {
            this.customDomain().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.azureFilesIdentityBasedAuthentication() != null) {
            this.azureFilesIdentityBasedAuthentication().validate();
        }
        if (this.routingPreference() != null) {
            this.routingPreference().validate();
        }
    }
}

