/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BlobRestoreRange
implements JsonSerializable<BlobRestoreRange> {
    private String startRange;
    private String endRange;
    private static final ClientLogger LOGGER = new ClientLogger(BlobRestoreRange.class);

    public String startRange() {
        return this.startRange;
    }

    public BlobRestoreRange withStartRange(String startRange) {
        this.startRange = startRange;
        return this;
    }

    public String endRange() {
        return this.endRange;
    }

    public BlobRestoreRange withEndRange(String endRange) {
        this.endRange = endRange;
        return this;
    }

    public void validate() {
        if (this.startRange() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startRange in model BlobRestoreRange"));
        }
        if (this.endRange() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endRange in model BlobRestoreRange"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startRange", this.startRange);
        jsonWriter.writeStringField("endRange", this.endRange);
        return jsonWriter.writeEndObject();
    }

    public static BlobRestoreRange fromJson(JsonReader jsonReader) throws IOException {
        return (BlobRestoreRange)jsonReader.readObject(reader -> {
            BlobRestoreRange deserializedBlobRestoreRange = new BlobRestoreRange();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startRange".equals(fieldName)) {
                    deserializedBlobRestoreRange.startRange = reader.getString();
                    continue;
                }
                if ("endRange".equals(fieldName)) {
                    deserializedBlobRestoreRange.endRange = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobRestoreRange;
        });
    }
}

