/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ManagementPolicyDefinition;
import com.azure.resourcemanager.storage.models.RuleType;
import java.io.IOException;

public final class ManagementPolicyRule
implements JsonSerializable<ManagementPolicyRule> {
    private Boolean enabled;
    private String name;
    private RuleType type;
    private ManagementPolicyDefinition definition;
    private static final ClientLogger LOGGER = new ClientLogger(ManagementPolicyRule.class);

    public Boolean enabled() {
        return this.enabled;
    }

    public ManagementPolicyRule withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ManagementPolicyRule withName(String name) {
        this.name = name;
        return this;
    }

    public RuleType type() {
        return this.type;
    }

    public ManagementPolicyRule withType(RuleType type) {
        this.type = type;
        return this;
    }

    public ManagementPolicyDefinition definition() {
        return this.definition;
    }

    public ManagementPolicyRule withDefinition(ManagementPolicyDefinition definition) {
        this.definition = definition;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ManagementPolicyRule"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ManagementPolicyRule"));
        }
        if (this.definition() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property definition in model ManagementPolicyRule"));
        }
        this.definition().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("definition", (JsonSerializable)this.definition);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    public static ManagementPolicyRule fromJson(JsonReader jsonReader) throws IOException {
        return (ManagementPolicyRule)jsonReader.readObject(reader -> {
            ManagementPolicyRule deserializedManagementPolicyRule = new ManagementPolicyRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedManagementPolicyRule.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagementPolicyRule.type = RuleType.fromString(reader.getString());
                    continue;
                }
                if ("definition".equals(fieldName)) {
                    deserializedManagementPolicyRule.definition = ManagementPolicyDefinition.fromJson(reader);
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedManagementPolicyRule.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagementPolicyRule;
        });
    }
}

