/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.SkuConversionStatus;
import com.azure.resourcemanager.storage.models.SkuName;
import java.io.IOException;

public final class StorageAccountSkuConversionStatus
implements JsonSerializable<StorageAccountSkuConversionStatus> {
    private SkuConversionStatus skuConversionStatus;
    private SkuName targetSkuName;
    private String startTime;
    private String endTime;

    public SkuConversionStatus skuConversionStatus() {
        return this.skuConversionStatus;
    }

    public SkuName targetSkuName() {
        return this.targetSkuName;
    }

    public StorageAccountSkuConversionStatus withTargetSkuName(SkuName targetSkuName) {
        this.targetSkuName = targetSkuName;
        return this;
    }

    public String startTime() {
        return this.startTime;
    }

    public String endTime() {
        return this.endTime;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetSkuName", this.targetSkuName == null ? null : this.targetSkuName.toString());
        return jsonWriter.writeEndObject();
    }

    public static StorageAccountSkuConversionStatus fromJson(JsonReader jsonReader) throws IOException {
        return (StorageAccountSkuConversionStatus)jsonReader.readObject(reader -> {
            StorageAccountSkuConversionStatus deserializedStorageAccountSkuConversionStatus = new StorageAccountSkuConversionStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("skuConversionStatus".equals(fieldName)) {
                    deserializedStorageAccountSkuConversionStatus.skuConversionStatus = SkuConversionStatus.fromString(reader.getString());
                    continue;
                }
                if ("targetSkuName".equals(fieldName)) {
                    deserializedStorageAccountSkuConversionStatus.targetSkuName = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedStorageAccountSkuConversionStatus.startTime = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedStorageAccountSkuConversionStatus.endTime = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccountSkuConversionStatus;
        });
    }
}

