/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ObjectReplicationPolicyFilter;
import java.io.IOException;

public final class ObjectReplicationPolicyRule
implements JsonSerializable<ObjectReplicationPolicyRule> {
    private String ruleId;
    private String sourceContainer;
    private String destinationContainer;
    private ObjectReplicationPolicyFilter filters;
    private static final ClientLogger LOGGER = new ClientLogger(ObjectReplicationPolicyRule.class);

    public String ruleId() {
        return this.ruleId;
    }

    public ObjectReplicationPolicyRule withRuleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public String sourceContainer() {
        return this.sourceContainer;
    }

    public ObjectReplicationPolicyRule withSourceContainer(String sourceContainer) {
        this.sourceContainer = sourceContainer;
        return this;
    }

    public String destinationContainer() {
        return this.destinationContainer;
    }

    public ObjectReplicationPolicyRule withDestinationContainer(String destinationContainer) {
        this.destinationContainer = destinationContainer;
        return this;
    }

    public ObjectReplicationPolicyFilter filters() {
        return this.filters;
    }

    public ObjectReplicationPolicyRule withFilters(ObjectReplicationPolicyFilter filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.sourceContainer() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceContainer in model ObjectReplicationPolicyRule"));
        }
        if (this.destinationContainer() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destinationContainer in model ObjectReplicationPolicyRule"));
        }
        if (this.filters() != null) {
            this.filters().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceContainer", this.sourceContainer);
        jsonWriter.writeStringField("destinationContainer", this.destinationContainer);
        jsonWriter.writeStringField("ruleId", this.ruleId);
        jsonWriter.writeJsonField("filters", (JsonSerializable)this.filters);
        return jsonWriter.writeEndObject();
    }

    public static ObjectReplicationPolicyRule fromJson(JsonReader jsonReader) throws IOException {
        return (ObjectReplicationPolicyRule)jsonReader.readObject(reader -> {
            ObjectReplicationPolicyRule deserializedObjectReplicationPolicyRule = new ObjectReplicationPolicyRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceContainer".equals(fieldName)) {
                    deserializedObjectReplicationPolicyRule.sourceContainer = reader.getString();
                    continue;
                }
                if ("destinationContainer".equals(fieldName)) {
                    deserializedObjectReplicationPolicyRule.destinationContainer = reader.getString();
                    continue;
                }
                if ("ruleId".equals(fieldName)) {
                    deserializedObjectReplicationPolicyRule.ruleId = reader.getString();
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    deserializedObjectReplicationPolicyRule.filters = ObjectReplicationPolicyFilter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedObjectReplicationPolicyRule;
        });
    }
}

