/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.TriggerParameters;
import com.azure.resourcemanager.storage.models.TriggerType;
import java.io.IOException;

public final class ExecutionTrigger
implements JsonSerializable<ExecutionTrigger> {
    private TriggerType type;
    private TriggerParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(ExecutionTrigger.class);

    public TriggerType type() {
        return this.type;
    }

    public ExecutionTrigger withType(TriggerType type) {
        this.type = type;
        return this;
    }

    public TriggerParameters parameters() {
        return this.parameters;
    }

    public ExecutionTrigger withParameters(TriggerParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ExecutionTrigger"));
        }
        if (this.parameters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parameters in model ExecutionTrigger"));
        }
        this.parameters().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static ExecutionTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutionTrigger)jsonReader.readObject(reader -> {
            ExecutionTrigger deserializedExecutionTrigger = new ExecutionTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedExecutionTrigger.type = TriggerType.fromString(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedExecutionTrigger.parameters = TriggerParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecutionTrigger;
        });
    }
}

