/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ChangeFeed;
import com.azure.resourcemanager.storage.models.CorsRules;
import com.azure.resourcemanager.storage.models.DeleteRetentionPolicy;
import com.azure.resourcemanager.storage.models.LastAccessTimeTrackingPolicy;
import com.azure.resourcemanager.storage.models.RestorePolicyProperties;
import java.io.IOException;

public final class BlobServicePropertiesProperties
implements JsonSerializable<BlobServicePropertiesProperties> {
    private CorsRules cors;
    private String defaultServiceVersion;
    private DeleteRetentionPolicy deleteRetentionPolicy;
    private Boolean isVersioningEnabled;
    private Boolean automaticSnapshotPolicyEnabled;
    private ChangeFeed changeFeed;
    private RestorePolicyProperties restorePolicy;
    private DeleteRetentionPolicy containerDeleteRetentionPolicy;
    private LastAccessTimeTrackingPolicy lastAccessTimeTrackingPolicy;

    public CorsRules cors() {
        return this.cors;
    }

    public BlobServicePropertiesProperties withCors(CorsRules cors) {
        this.cors = cors;
        return this;
    }

    public String defaultServiceVersion() {
        return this.defaultServiceVersion;
    }

    public BlobServicePropertiesProperties withDefaultServiceVersion(String defaultServiceVersion) {
        this.defaultServiceVersion = defaultServiceVersion;
        return this;
    }

    public DeleteRetentionPolicy deleteRetentionPolicy() {
        return this.deleteRetentionPolicy;
    }

    public BlobServicePropertiesProperties withDeleteRetentionPolicy(DeleteRetentionPolicy deleteRetentionPolicy) {
        this.deleteRetentionPolicy = deleteRetentionPolicy;
        return this;
    }

    public Boolean isVersioningEnabled() {
        return this.isVersioningEnabled;
    }

    public BlobServicePropertiesProperties withIsVersioningEnabled(Boolean isVersioningEnabled) {
        this.isVersioningEnabled = isVersioningEnabled;
        return this;
    }

    public Boolean automaticSnapshotPolicyEnabled() {
        return this.automaticSnapshotPolicyEnabled;
    }

    public BlobServicePropertiesProperties withAutomaticSnapshotPolicyEnabled(Boolean automaticSnapshotPolicyEnabled) {
        this.automaticSnapshotPolicyEnabled = automaticSnapshotPolicyEnabled;
        return this;
    }

    public ChangeFeed changeFeed() {
        return this.changeFeed;
    }

    public BlobServicePropertiesProperties withChangeFeed(ChangeFeed changeFeed) {
        this.changeFeed = changeFeed;
        return this;
    }

    public RestorePolicyProperties restorePolicy() {
        return this.restorePolicy;
    }

    public BlobServicePropertiesProperties withRestorePolicy(RestorePolicyProperties restorePolicy) {
        this.restorePolicy = restorePolicy;
        return this;
    }

    public DeleteRetentionPolicy containerDeleteRetentionPolicy() {
        return this.containerDeleteRetentionPolicy;
    }

    public BlobServicePropertiesProperties withContainerDeleteRetentionPolicy(DeleteRetentionPolicy containerDeleteRetentionPolicy) {
        this.containerDeleteRetentionPolicy = containerDeleteRetentionPolicy;
        return this;
    }

    public LastAccessTimeTrackingPolicy lastAccessTimeTrackingPolicy() {
        return this.lastAccessTimeTrackingPolicy;
    }

    public BlobServicePropertiesProperties withLastAccessTimeTrackingPolicy(LastAccessTimeTrackingPolicy lastAccessTimeTrackingPolicy) {
        this.lastAccessTimeTrackingPolicy = lastAccessTimeTrackingPolicy;
        return this;
    }

    public void validate() {
        if (this.cors() != null) {
            this.cors().validate();
        }
        if (this.deleteRetentionPolicy() != null) {
            this.deleteRetentionPolicy().validate();
        }
        if (this.changeFeed() != null) {
            this.changeFeed().validate();
        }
        if (this.restorePolicy() != null) {
            this.restorePolicy().validate();
        }
        if (this.containerDeleteRetentionPolicy() != null) {
            this.containerDeleteRetentionPolicy().validate();
        }
        if (this.lastAccessTimeTrackingPolicy() != null) {
            this.lastAccessTimeTrackingPolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("cors", (JsonSerializable)this.cors);
        jsonWriter.writeStringField("defaultServiceVersion", this.defaultServiceVersion);
        jsonWriter.writeJsonField("deleteRetentionPolicy", (JsonSerializable)this.deleteRetentionPolicy);
        jsonWriter.writeBooleanField("isVersioningEnabled", this.isVersioningEnabled);
        jsonWriter.writeBooleanField("automaticSnapshotPolicyEnabled", this.automaticSnapshotPolicyEnabled);
        jsonWriter.writeJsonField("changeFeed", (JsonSerializable)this.changeFeed);
        jsonWriter.writeJsonField("restorePolicy", (JsonSerializable)this.restorePolicy);
        jsonWriter.writeJsonField("containerDeleteRetentionPolicy", (JsonSerializable)this.containerDeleteRetentionPolicy);
        jsonWriter.writeJsonField("lastAccessTimeTrackingPolicy", (JsonSerializable)this.lastAccessTimeTrackingPolicy);
        return jsonWriter.writeEndObject();
    }

    public static BlobServicePropertiesProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BlobServicePropertiesProperties)jsonReader.readObject(reader -> {
            BlobServicePropertiesProperties deserializedBlobServicePropertiesProperties = new BlobServicePropertiesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cors".equals(fieldName)) {
                    deserializedBlobServicePropertiesProperties.cors = CorsRules.fromJson(reader);
                    continue;
                }
                if ("defaultServiceVersion".equals(fieldName)) {
                    deserializedBlobServicePropertiesProperties.defaultServiceVersion = reader.getString();
                    continue;
                }
                if ("deleteRetentionPolicy".equals(fieldName)) {
                    deserializedBlobServicePropertiesProperties.deleteRetentionPolicy = DeleteRetentionPolicy.fromJson(reader);
                    continue;
                }
                if ("isVersioningEnabled".equals(fieldName)) {
                    deserializedBlobServicePropertiesProperties.isVersioningEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("automaticSnapshotPolicyEnabled".equals(fieldName)) {
                    deserializedBlobServicePropertiesProperties.automaticSnapshotPolicyEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("changeFeed".equals(fieldName)) {
                    deserializedBlobServicePropertiesProperties.changeFeed = ChangeFeed.fromJson(reader);
                    continue;
                }
                if ("restorePolicy".equals(fieldName)) {
                    deserializedBlobServicePropertiesProperties.restorePolicy = RestorePolicyProperties.fromJson(reader);
                    continue;
                }
                if ("containerDeleteRetentionPolicy".equals(fieldName)) {
                    deserializedBlobServicePropertiesProperties.containerDeleteRetentionPolicy = DeleteRetentionPolicy.fromJson(reader);
                    continue;
                }
                if ("lastAccessTimeTrackingPolicy".equals(fieldName)) {
                    deserializedBlobServicePropertiesProperties.lastAccessTimeTrackingPolicy = LastAccessTimeTrackingPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobServicePropertiesProperties;
        });
    }
}

