/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.azure.resourcemanager.storage.fluent.BlobContainersClient;
import com.azure.resourcemanager.storage.fluent.BlobInventoryPoliciesClient;
import com.azure.resourcemanager.storage.fluent.BlobServicesClient;
import com.azure.resourcemanager.storage.fluent.DeletedAccountsClient;
import com.azure.resourcemanager.storage.fluent.EncryptionScopesClient;
import com.azure.resourcemanager.storage.fluent.FileServicesClient;
import com.azure.resourcemanager.storage.fluent.FileSharesClient;
import com.azure.resourcemanager.storage.fluent.ManagementPoliciesClient;
import com.azure.resourcemanager.storage.fluent.ObjectReplicationPoliciesOperationsClient;
import com.azure.resourcemanager.storage.fluent.OperationsClient;
import com.azure.resourcemanager.storage.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.storage.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.storage.fluent.QueueServicesClient;
import com.azure.resourcemanager.storage.fluent.QueuesClient;
import com.azure.resourcemanager.storage.fluent.SkusClient;
import com.azure.resourcemanager.storage.fluent.StorageAccountsClient;
import com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.azure.resourcemanager.storage.fluent.TableServicesClient;
import com.azure.resourcemanager.storage.fluent.TablesClient;
import com.azure.resourcemanager.storage.fluent.UsagesClient;
import com.azure.resourcemanager.storage.implementation.BlobContainersClientImpl;
import com.azure.resourcemanager.storage.implementation.BlobInventoryPoliciesClientImpl;
import com.azure.resourcemanager.storage.implementation.BlobServicesClientImpl;
import com.azure.resourcemanager.storage.implementation.DeletedAccountsClientImpl;
import com.azure.resourcemanager.storage.implementation.EncryptionScopesClientImpl;
import com.azure.resourcemanager.storage.implementation.FileServicesClientImpl;
import com.azure.resourcemanager.storage.implementation.FileSharesClientImpl;
import com.azure.resourcemanager.storage.implementation.ManagementPoliciesClientImpl;
import com.azure.resourcemanager.storage.implementation.ObjectReplicationPoliciesOperationsClientImpl;
import com.azure.resourcemanager.storage.implementation.OperationsClientImpl;
import com.azure.resourcemanager.storage.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.storage.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.storage.implementation.QueueServicesClientImpl;
import com.azure.resourcemanager.storage.implementation.QueuesClientImpl;
import com.azure.resourcemanager.storage.implementation.SkusClientImpl;
import com.azure.resourcemanager.storage.implementation.StorageAccountsClientImpl;
import com.azure.resourcemanager.storage.implementation.TableServicesClientImpl;
import com.azure.resourcemanager.storage.implementation.TablesClientImpl;
import com.azure.resourcemanager.storage.implementation.UsagesClientImpl;
import java.time.Duration;

public final class StorageManagementClientImpl
extends AzureServiceClient
implements StorageManagementClient {
    private final ClientLogger logger = new ClientLogger(StorageManagementClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final SkusClient skus;
    private final StorageAccountsClient storageAccounts;
    private final DeletedAccountsClient deletedAccounts;
    private final UsagesClient usages;
    private final ManagementPoliciesClient managementPolicies;
    private final BlobInventoryPoliciesClient blobInventoryPolicies;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final ObjectReplicationPoliciesOperationsClient objectReplicationPoliciesOperations;
    private final EncryptionScopesClient encryptionScopes;
    private final BlobServicesClient blobServices;
    private final BlobContainersClient blobContainers;
    private final FileServicesClient fileServices;
    private final FileSharesClient fileShares;
    private final QueueServicesClient queueServices;
    private final QueuesClient queues;
    private final TableServicesClient tableServices;
    private final TablesClient tables;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public SkusClient getSkus() {
        return this.skus;
    }

    @Override
    public StorageAccountsClient getStorageAccounts() {
        return this.storageAccounts;
    }

    @Override
    public DeletedAccountsClient getDeletedAccounts() {
        return this.deletedAccounts;
    }

    @Override
    public UsagesClient getUsages() {
        return this.usages;
    }

    @Override
    public ManagementPoliciesClient getManagementPolicies() {
        return this.managementPolicies;
    }

    @Override
    public BlobInventoryPoliciesClient getBlobInventoryPolicies() {
        return this.blobInventoryPolicies;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public ObjectReplicationPoliciesOperationsClient getObjectReplicationPoliciesOperations() {
        return this.objectReplicationPoliciesOperations;
    }

    @Override
    public EncryptionScopesClient getEncryptionScopes() {
        return this.encryptionScopes;
    }

    @Override
    public BlobServicesClient getBlobServices() {
        return this.blobServices;
    }

    @Override
    public BlobContainersClient getBlobContainers() {
        return this.blobContainers;
    }

    @Override
    public FileServicesClient getFileServices() {
        return this.fileServices;
    }

    @Override
    public FileSharesClient getFileShares() {
        return this.fileShares;
    }

    @Override
    public QueueServicesClient getQueueServices() {
        return this.queueServices;
    }

    @Override
    public QueuesClient getQueues() {
        return this.queues;
    }

    @Override
    public TableServicesClient getTableServices() {
        return this.tableServices;
    }

    @Override
    public TablesClient getTables() {
        return this.tables;
    }

    StorageManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2021-01-01";
        this.operations = new OperationsClientImpl(this);
        this.skus = new SkusClientImpl(this);
        this.storageAccounts = new StorageAccountsClientImpl(this);
        this.deletedAccounts = new DeletedAccountsClientImpl(this);
        this.usages = new UsagesClientImpl(this);
        this.managementPolicies = new ManagementPoliciesClientImpl(this);
        this.blobInventoryPolicies = new BlobInventoryPoliciesClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.objectReplicationPoliciesOperations = new ObjectReplicationPoliciesOperationsClientImpl(this);
        this.encryptionScopes = new EncryptionScopesClientImpl(this);
        this.blobServices = new BlobServicesClientImpl(this);
        this.blobContainers = new BlobContainersClientImpl(this);
        this.fileServices = new FileServicesClientImpl(this);
        this.fileShares = new FileSharesClientImpl(this);
        this.queueServices = new QueueServicesClientImpl(this);
        this.queues = new QueuesClientImpl(this);
        this.tableServices = new TableServicesClientImpl(this);
        this.tables = new TablesClientImpl(this);
    }
}

