/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.fluent.StorageAccountsClient;
import com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountInner;
import com.azure.resourcemanager.storage.implementation.StorageEncryptionHelper;
import com.azure.resourcemanager.storage.implementation.StorageNetworkRulesHelper;
import com.azure.resourcemanager.storage.models.AccessTier;
import com.azure.resourcemanager.storage.models.AccountStatuses;
import com.azure.resourcemanager.storage.models.AzureFilesIdentityBasedAuthentication;
import com.azure.resourcemanager.storage.models.CustomDomain;
import com.azure.resourcemanager.storage.models.DirectoryServiceOptions;
import com.azure.resourcemanager.storage.models.Identity;
import com.azure.resourcemanager.storage.models.IdentityType;
import com.azure.resourcemanager.storage.models.Kind;
import com.azure.resourcemanager.storage.models.LargeFileSharesState;
import com.azure.resourcemanager.storage.models.ProvisioningState;
import com.azure.resourcemanager.storage.models.PublicEndpoints;
import com.azure.resourcemanager.storage.models.Sku;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.azure.resourcemanager.storage.models.StorageAccountCreateParameters;
import com.azure.resourcemanager.storage.models.StorageAccountEncryptionKeySource;
import com.azure.resourcemanager.storage.models.StorageAccountEncryptionStatus;
import com.azure.resourcemanager.storage.models.StorageAccountKey;
import com.azure.resourcemanager.storage.models.StorageAccountSkuType;
import com.azure.resourcemanager.storage.models.StorageAccountUpdateParameters;
import com.azure.resourcemanager.storage.models.StorageService;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

class StorageAccountImpl
extends GroupableResourceImpl<StorageAccount, StorageAccountInner, StorageAccountImpl, StorageManager>
implements StorageAccount,
StorageAccount.Definition,
StorageAccount.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private PublicEndpoints publicEndpoints;
    private AccountStatuses accountStatuses;
    private StorageAccountCreateParameters createParameters = new StorageAccountCreateParameters();
    private StorageAccountUpdateParameters updateParameters;
    private StorageNetworkRulesHelper networkRulesHelper = new StorageNetworkRulesHelper(this.createParameters);
    private StorageEncryptionHelper encryptionHelper = new StorageEncryptionHelper(this.createParameters);

    StorageAccountImpl(String name, StorageAccountInner innerModel, StorageManager storageManager) {
        super(name, (Resource)innerModel, (Manager)storageManager);
    }

    @Override
    public AccountStatuses accountStatuses() {
        if (this.accountStatuses == null) {
            this.accountStatuses = new AccountStatuses(((StorageAccountInner)((Object)this.innerModel())).statusOfPrimary(), ((StorageAccountInner)((Object)this.innerModel())).statusOfSecondary());
        }
        return this.accountStatuses;
    }

    @Override
    public StorageAccountSkuType skuType() {
        return StorageAccountSkuType.fromSkuName(((StorageAccountInner)((Object)this.innerModel())).sku().name());
    }

    @Override
    public Kind kind() {
        return ((StorageAccountInner)((Object)this.innerModel())).kind();
    }

    @Override
    public OffsetDateTime creationTime() {
        return ((StorageAccountInner)((Object)this.innerModel())).creationTime();
    }

    @Override
    public CustomDomain customDomain() {
        return ((StorageAccountInner)((Object)this.innerModel())).customDomain();
    }

    @Override
    public OffsetDateTime lastGeoFailoverTime() {
        return ((StorageAccountInner)((Object)this.innerModel())).lastGeoFailoverTime();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((StorageAccountInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public PublicEndpoints endPoints() {
        if (this.publicEndpoints == null) {
            this.publicEndpoints = new PublicEndpoints(((StorageAccountInner)((Object)this.innerModel())).primaryEndpoints(), ((StorageAccountInner)((Object)this.innerModel())).secondaryEndpoints());
        }
        return this.publicEndpoints;
    }

    @Override
    public StorageAccountEncryptionKeySource encryptionKeySource() {
        return StorageEncryptionHelper.encryptionKeySource((StorageAccountInner)((Object)this.innerModel()));
    }

    @Override
    public Map<StorageService, StorageAccountEncryptionStatus> encryptionStatuses() {
        return StorageEncryptionHelper.encryptionStatuses((StorageAccountInner)((Object)this.innerModel()));
    }

    @Override
    public AccessTier accessTier() {
        return ((StorageAccountInner)((Object)this.innerModel())).accessTier();
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        if (((StorageAccountInner)((Object)this.innerModel())).identity() == null) {
            return null;
        }
        return ((StorageAccountInner)((Object)this.innerModel())).identity().tenantId();
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        if (((StorageAccountInner)((Object)this.innerModel())).identity() == null) {
            return null;
        }
        return ((StorageAccountInner)((Object)this.innerModel())).identity().principalId();
    }

    @Override
    public boolean isAccessAllowedFromAllNetworks() {
        return StorageNetworkRulesHelper.isAccessAllowedFromAllNetworks((StorageAccountInner)((Object)this.innerModel()));
    }

    @Override
    public List<String> networkSubnetsWithAccess() {
        return StorageNetworkRulesHelper.networkSubnetsWithAccess((StorageAccountInner)((Object)this.innerModel()));
    }

    @Override
    public List<String> ipAddressesWithAccess() {
        return StorageNetworkRulesHelper.ipAddressesWithAccess((StorageAccountInner)((Object)this.innerModel()));
    }

    @Override
    public List<String> ipAddressRangesWithAccess() {
        return StorageNetworkRulesHelper.ipAddressRangesWithAccess((StorageAccountInner)((Object)this.innerModel()));
    }

    @Override
    public boolean canReadLogEntriesFromAnyNetwork() {
        return StorageNetworkRulesHelper.canReadLogEntriesFromAnyNetwork((StorageAccountInner)((Object)this.innerModel()));
    }

    @Override
    public boolean canReadMetricsFromAnyNetwork() {
        return StorageNetworkRulesHelper.canReadMetricsFromAnyNetwork((StorageAccountInner)((Object)this.innerModel()));
    }

    @Override
    public boolean canAccessFromAzureServices() {
        return StorageNetworkRulesHelper.canAccessFromAzureServices((StorageAccountInner)((Object)this.innerModel()));
    }

    @Override
    public boolean isAzureFilesAadIntegrationEnabled() {
        return ((StorageAccountInner)((Object)this.innerModel())).azureFilesIdentityBasedAuthentication() != null && ((StorageAccountInner)((Object)this.innerModel())).azureFilesIdentityBasedAuthentication().directoryServiceOptions() == DirectoryServiceOptions.AADDS;
    }

    @Override
    public boolean isHnsEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((StorageAccountInner)((Object)this.innerModel())).isHnsEnabled());
    }

    @Override
    public boolean isLargeFileSharesEnabled() {
        return ((StorageAccountInner)((Object)this.innerModel())).largeFileSharesState() == LargeFileSharesState.ENABLED;
    }

    @Override
    public List<StorageAccountKey> getKeys() {
        return (List)this.getKeysAsync().block();
    }

    @Override
    public Mono<List<StorageAccountKey>> getKeysAsync() {
        return ((StorageManagementClient)((StorageManager)this.manager()).serviceClient()).getStorageAccounts().listKeysAsync(this.resourceGroupName(), this.name()).map(storageAccountListKeysResultInner -> storageAccountListKeysResultInner.keys());
    }

    @Override
    public List<StorageAccountKey> regenerateKey(String keyName) {
        return (List)this.regenerateKeyAsync(keyName).block();
    }

    @Override
    public Mono<List<StorageAccountKey>> regenerateKeyAsync(String keyName) {
        return ((StorageManagementClient)((StorageManager)this.manager()).serviceClient()).getStorageAccounts().regenerateKeyAsync(this.resourceGroupName(), this.name(), keyName).map(storageAccountListKeysResultInner -> storageAccountListKeysResultInner.keys());
    }

    public Mono<StorageAccount> refreshAsync() {
        return super.refreshAsync().map(storageAccount -> {
            StorageAccountImpl impl = (StorageAccountImpl)storageAccount;
            impl.clearWrapperProperties();
            return impl;
        });
    }

    protected Mono<StorageAccountInner> getInnerAsync() {
        return ((StorageManagementClient)((StorageManager)this.manager()).serviceClient()).getStorageAccounts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public StorageAccountImpl withSku(StorageAccountSkuType sku) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(sku.name()));
        } else {
            this.updateParameters.withSku(new Sku().withName(sku.name()));
        }
        return this;
    }

    @Override
    public StorageAccountImpl withBlobStorageAccountKind() {
        this.createParameters.withKind(Kind.BLOB_STORAGE);
        return this;
    }

    @Override
    public StorageAccountImpl withGeneralPurposeAccountKind() {
        this.createParameters.withKind(Kind.STORAGE);
        return this;
    }

    @Override
    public StorageAccountImpl withGeneralPurposeAccountKindV2() {
        this.createParameters.withKind(Kind.STORAGE_V2);
        return this;
    }

    @Override
    public StorageAccountImpl withBlockBlobStorageAccountKind() {
        this.createParameters.withKind(Kind.BLOCK_BLOB_STORAGE);
        return this;
    }

    @Override
    public StorageAccountImpl withFileStorageAccountKind() {
        this.createParameters.withKind(Kind.FILE_STORAGE);
        return this;
    }

    @Override
    public StorageAccountImpl withBlobEncryption() {
        this.encryptionHelper.withBlobEncryption();
        return this;
    }

    @Override
    public StorageAccountImpl withFileEncryption() {
        this.encryptionHelper.withFileEncryption();
        return this;
    }

    @Override
    public StorageAccountImpl withEncryptionKeyFromKeyVault(String keyVaultUri, String keyName, String keyVersion) {
        this.encryptionHelper.withEncryptionKeyFromKeyVault(keyVaultUri, keyName, keyVersion);
        return this;
    }

    @Override
    public StorageAccountImpl withoutBlobEncryption() {
        this.encryptionHelper.withoutBlobEncryption();
        return this;
    }

    @Override
    public StorageAccountImpl withoutFileEncryption() {
        this.encryptionHelper.withoutFileEncryption();
        return this;
    }

    private void clearWrapperProperties() {
        this.accountStatuses = null;
        this.publicEndpoints = null;
    }

    public StorageAccountImpl update() {
        this.createParameters = null;
        this.updateParameters = new StorageAccountUpdateParameters();
        this.networkRulesHelper = new StorageNetworkRulesHelper(this.updateParameters, (StorageAccountInner)((Object)this.innerModel()));
        this.encryptionHelper = new StorageEncryptionHelper(this.updateParameters, (StorageAccountInner)((Object)this.innerModel()));
        return (StorageAccountImpl)super.update();
    }

    @Override
    public StorageAccountImpl withCustomDomain(CustomDomain customDomain) {
        if (this.isInCreateMode()) {
            this.createParameters.withCustomDomain(customDomain);
        } else {
            this.updateParameters.withCustomDomain(customDomain);
        }
        return this;
    }

    @Override
    public StorageAccountImpl withCustomDomain(String name) {
        return this.withCustomDomain(new CustomDomain().withName(name));
    }

    @Override
    public StorageAccountImpl withCustomDomain(String name, boolean useSubDomain) {
        return this.withCustomDomain(new CustomDomain().withName(name).withUseSubDomainName(useSubDomain));
    }

    @Override
    public StorageAccountImpl withAccessTier(AccessTier accessTier) {
        if (this.isInCreateMode()) {
            this.createParameters.withAccessTier(accessTier);
        } else {
            if (((StorageAccountInner)((Object)this.innerModel())).kind() != Kind.BLOB_STORAGE) {
                throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Access tier can not be changed for general purpose storage accounts."));
            }
            this.updateParameters.withAccessTier(accessTier);
        }
        return this;
    }

    @Override
    public StorageAccountImpl withSystemAssignedManagedServiceIdentity() {
        if (((StorageAccountInner)((Object)this.innerModel())).identity() == null) {
            if (this.isInCreateMode()) {
                this.createParameters.withIdentity(new Identity().withType(IdentityType.SYSTEM_ASSIGNED));
            } else {
                this.updateParameters.withIdentity(new Identity().withType(IdentityType.SYSTEM_ASSIGNED));
            }
        }
        return this;
    }

    @Override
    public StorageAccountImpl withOnlyHttpsTraffic() {
        if (this.isInCreateMode()) {
            this.createParameters.withEnableHttpsTrafficOnly(true);
        } else {
            this.updateParameters.withEnableHttpsTrafficOnly(true);
        }
        return this;
    }

    @Override
    public StorageAccountImpl withHttpAndHttpsTraffic() {
        this.updateParameters.withEnableHttpsTrafficOnly(false);
        return this;
    }

    @Override
    public StorageAccountImpl withAccessFromAllNetworks() {
        this.networkRulesHelper.withAccessFromAllNetworks();
        return this;
    }

    @Override
    public StorageAccountImpl withAccessFromSelectedNetworks() {
        this.networkRulesHelper.withAccessFromSelectedNetworks();
        return this;
    }

    @Override
    public StorageAccountImpl withAccessFromNetworkSubnet(String subnetId) {
        this.networkRulesHelper.withAccessFromNetworkSubnet(subnetId);
        return this;
    }

    @Override
    public StorageAccountImpl withAccessFromIpAddress(String ipAddress) {
        this.networkRulesHelper.withAccessFromIpAddress(ipAddress);
        return this;
    }

    @Override
    public StorageAccountImpl withAccessFromIpAddressRange(String ipAddressCidr) {
        this.networkRulesHelper.withAccessFromIpAddressRange(ipAddressCidr);
        return this;
    }

    @Override
    public StorageAccountImpl withReadAccessToLogEntriesFromAnyNetwork() {
        this.networkRulesHelper.withReadAccessToLoggingFromAnyNetwork();
        return this;
    }

    @Override
    public StorageAccountImpl withReadAccessToMetricsFromAnyNetwork() {
        this.networkRulesHelper.withReadAccessToMetricsFromAnyNetwork();
        return this;
    }

    @Override
    public StorageAccountImpl withAccessFromAzureServices() {
        this.networkRulesHelper.withAccessAllowedFromAzureServices();
        return this;
    }

    @Override
    public StorageAccountImpl withoutNetworkSubnetAccess(String subnetId) {
        this.networkRulesHelper.withoutNetworkSubnetAccess(subnetId);
        return this;
    }

    @Override
    public StorageAccountImpl withoutIpAddressAccess(String ipAddress) {
        this.networkRulesHelper.withoutIpAddressAccess(ipAddress);
        return this;
    }

    @Override
    public StorageAccountImpl withoutIpAddressRangeAccess(String ipAddressCidr) {
        this.networkRulesHelper.withoutIpAddressRangeAccess(ipAddressCidr);
        return this;
    }

    @Override
    public StorageAccount.Update withoutReadAccessToLoggingFromAnyNetwork() {
        this.networkRulesHelper.withoutReadAccessToLoggingFromAnyNetwork();
        return this;
    }

    @Override
    public StorageAccount.Update withoutReadAccessToMetricsFromAnyNetwork() {
        this.networkRulesHelper.withoutReadAccessToMetricsFromAnyNetwork();
        return this;
    }

    @Override
    public StorageAccount.Update withoutAccessFromAzureServices() {
        this.networkRulesHelper.withoutAccessFromAzureServices();
        return this;
    }

    @Override
    public StorageAccount.Update upgradeToGeneralPurposeAccountKindV2() {
        this.updateParameters.withKind(Kind.STORAGE_V2);
        return this;
    }

    public Mono<StorageAccount> createResourceAsync() {
        this.networkRulesHelper.setDefaultActionIfRequired();
        this.createParameters.withLocation(this.regionName());
        this.createParameters.withTags(((StorageAccountInner)((Object)this.innerModel())).tags());
        StorageAccountsClient client = ((StorageManagementClient)((StorageManager)this.manager()).serviceClient()).getStorageAccounts();
        return ((StorageManagementClient)((StorageManager)this.manager()).serviceClient()).getStorageAccounts().createAsync(this.resourceGroupName(), this.name(), this.createParameters).flatMap(storageAccountInner -> client.getByResourceGroupAsync(this.resourceGroupName(), this.name()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).doOnNext(storageAccount -> this.clearWrapperProperties()));
    }

    public Mono<StorageAccount> updateResourceAsync() {
        this.networkRulesHelper.setDefaultActionIfRequired();
        this.updateParameters.withTags(((StorageAccountInner)((Object)this.innerModel())).tags());
        return ((StorageManagementClient)((StorageManager)this.manager()).serviceClient()).getStorageAccounts().updateAsync(this.resourceGroupName(), this.name(), this.updateParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).doOnNext(storageAccount -> this.clearWrapperProperties());
    }

    @Override
    public StorageAccountImpl withAzureFilesAadIntegrationEnabled(boolean enabled) {
        if (this.isInCreateMode()) {
            if (enabled) {
                this.createParameters.withAzureFilesIdentityBasedAuthentication(new AzureFilesIdentityBasedAuthentication().withDirectoryServiceOptions(DirectoryServiceOptions.AADDS));
            }
        } else {
            if (this.createParameters.azureFilesIdentityBasedAuthentication() == null) {
                this.createParameters.withAzureFilesIdentityBasedAuthentication(new AzureFilesIdentityBasedAuthentication());
            }
            if (enabled) {
                this.updateParameters.azureFilesIdentityBasedAuthentication().withDirectoryServiceOptions(DirectoryServiceOptions.AADDS);
            } else {
                this.updateParameters.azureFilesIdentityBasedAuthentication().withDirectoryServiceOptions(DirectoryServiceOptions.NONE);
            }
        }
        return this;
    }

    @Override
    public StorageAccountImpl withLargeFileShares(boolean enabled) {
        if (this.isInCreateMode()) {
            if (enabled) {
                this.createParameters.withLargeFileSharesState(LargeFileSharesState.ENABLED);
            } else {
                this.createParameters.withLargeFileSharesState(LargeFileSharesState.DISABLED);
            }
        }
        return this;
    }

    @Override
    public StorageAccountImpl withHnsEnabled(boolean enabled) {
        this.createParameters.withIsHnsEnabled(enabled);
        return this;
    }
}

