/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storage.fluent.FileSharesClient;
import com.azure.resourcemanager.storage.fluent.models.FileShareInner;
import com.azure.resourcemanager.storage.fluent.models.FileShareItemInner;
import com.azure.resourcemanager.storage.implementation.StorageManagementClientImpl;
import com.azure.resourcemanager.storage.models.DeletedShare;
import com.azure.resourcemanager.storage.models.FileShareItems;
import com.azure.resourcemanager.storage.models.GetShareExpand;
import com.azure.resourcemanager.storage.models.ListSharesExpand;
import com.azure.resourcemanager.storage.models.PutSharesExpand;
import reactor.core.publisher.Mono;

public final class FileSharesClientImpl
implements FileSharesClient {
    private final ClientLogger logger = new ClientLogger(FileSharesClientImpl.class);
    private final FileSharesService service;
    private final StorageManagementClientImpl client;

    FileSharesClientImpl(StorageManagementClientImpl client) {
        this.service = (FileSharesService)RestProxy.create(FileSharesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<FileShareItemInner>> listSinglePageAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListSharesExpand expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), maxpagesize, filter, expand, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileShareItems)res.getValue()).value(), ((FileShareItems)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<FileShareItemInner>> listSinglePageAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListSharesExpand expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), maxpagesize, filter, expand, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileShareItems)res.getValue()).value(), ((FileShareItems)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<FileShareItemInner> listAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListSharesExpand expand) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<FileShareItemInner> listAsync(String resourceGroupName, String accountName) {
        String maxpagesize = null;
        String filter = null;
        ListSharesExpand expand = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<FileShareItemInner> listAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListSharesExpand expand, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, expand, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<FileShareItemInner> list(String resourceGroupName, String accountName) {
        String maxpagesize = null;
        String filter = null;
        ListSharesExpand expand = null;
        return new PagedIterable(this.listAsync(resourceGroupName, accountName, maxpagesize, filter, expand));
    }

    @Override
    public PagedIterable<FileShareItemInner> list(String resourceGroupName, String accountName, String maxpagesize, String filter, ListSharesExpand expand, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, accountName, maxpagesize, filter, expand, context));
    }

    @Override
    public Mono<Response<FileShareInner>> createWithResponseAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, PutSharesExpand expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (fileShare == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fileShare is required and cannot be null."));
        }
        fileShare.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, accountName, shareName, expand, this.client.getApiVersion(), this.client.getSubscriptionId(), fileShare, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<FileShareInner>> createWithResponseAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, PutSharesExpand expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (fileShare == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fileShare is required and cannot be null."));
        }
        fileShare.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, accountName, shareName, expand, this.client.getApiVersion(), this.client.getSubscriptionId(), fileShare, "application/json", context);
    }

    @Override
    public Mono<FileShareInner> createAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, PutSharesExpand expand) {
        return this.createWithResponseAsync(resourceGroupName, accountName, shareName, fileShare, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((FileShareInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<FileShareInner> createAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        PutSharesExpand expand = null;
        return this.createWithResponseAsync(resourceGroupName, accountName, shareName, fileShare, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((FileShareInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public FileShareInner create(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        PutSharesExpand expand = null;
        return (FileShareInner)((Object)this.createAsync(resourceGroupName, accountName, shareName, fileShare, expand).block());
    }

    @Override
    public Response<FileShareInner> createWithResponse(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, PutSharesExpand expand, Context context) {
        return (Response)this.createWithResponseAsync(resourceGroupName, accountName, shareName, fileShare, expand, context).block();
    }

    @Override
    public Mono<Response<FileShareInner>> updateWithResponseAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (fileShare == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fileShare is required and cannot be null."));
        }
        fileShare.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), fileShare, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<FileShareInner>> updateWithResponseAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (fileShare == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter fileShare is required and cannot be null."));
        }
        fileShare.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), fileShare, "application/json", context);
    }

    @Override
    public Mono<FileShareInner> updateAsync(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        return this.updateWithResponseAsync(resourceGroupName, accountName, shareName, fileShare).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((FileShareInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public FileShareInner update(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        return (FileShareInner)((Object)this.updateAsync(resourceGroupName, accountName, shareName, fileShare).block());
    }

    @Override
    public Response<FileShareInner> updateWithResponse(String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, accountName, shareName, fileShare, context).block();
    }

    @Override
    public Mono<Response<FileShareInner>> getWithResponseAsync(String resourceGroupName, String accountName, String shareName, GetShareExpand expand, String xMsSnapshot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), expand, xMsSnapshot, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<FileShareInner>> getWithResponseAsync(String resourceGroupName, String accountName, String shareName, GetShareExpand expand, String xMsSnapshot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), expand, xMsSnapshot, "application/json", context);
    }

    @Override
    public Mono<FileShareInner> getAsync(String resourceGroupName, String accountName, String shareName, GetShareExpand expand, String xMsSnapshot) {
        return this.getWithResponseAsync(resourceGroupName, accountName, shareName, expand, xMsSnapshot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((FileShareInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<FileShareInner> getAsync(String resourceGroupName, String accountName, String shareName) {
        GetShareExpand expand = null;
        String xMsSnapshot = null;
        return this.getWithResponseAsync(resourceGroupName, accountName, shareName, expand, xMsSnapshot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((FileShareInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public FileShareInner get(String resourceGroupName, String accountName, String shareName) {
        GetShareExpand expand = null;
        String xMsSnapshot = null;
        return (FileShareInner)((Object)this.getAsync(resourceGroupName, accountName, shareName, expand, xMsSnapshot).block());
    }

    @Override
    public Response<FileShareInner> getWithResponse(String resourceGroupName, String accountName, String shareName, GetShareExpand expand, String xMsSnapshot, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, accountName, shareName, expand, xMsSnapshot, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName, String shareName, String xMsSnapshot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), xMsSnapshot, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName, String shareName, String xMsSnapshot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), xMsSnapshot, "application/json", context);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String accountName, String shareName, String xMsSnapshot) {
        return this.deleteWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String accountName, String shareName) {
        String xMsSnapshot = null;
        return this.deleteWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String shareName) {
        String xMsSnapshot = null;
        this.deleteAsync(resourceGroupName, accountName, shareName, xMsSnapshot).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String accountName, String shareName, String xMsSnapshot, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot, context).block();
    }

    @Override
    public Mono<Response<Void>> restoreWithResponseAsync(String resourceGroupName, String accountName, String shareName, String deletedShareName, String deletedShareVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deletedShareName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deletedShareName is required and cannot be null."));
        }
        if (deletedShareVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deletedShareVersion is required and cannot be null."));
        }
        String accept = "application/json";
        DeletedShare deletedShare = new DeletedShare();
        deletedShare.withDeletedShareName(deletedShareName);
        deletedShare.withDeletedShareVersion(deletedShareVersion);
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), deletedShare, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> restoreWithResponseAsync(String resourceGroupName, String accountName, String shareName, String deletedShareName, String deletedShareVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deletedShareName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deletedShareName is required and cannot be null."));
        }
        if (deletedShareVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deletedShareVersion is required and cannot be null."));
        }
        String accept = "application/json";
        DeletedShare deletedShare = new DeletedShare();
        deletedShare.withDeletedShareName(deletedShareName);
        deletedShare.withDeletedShareVersion(deletedShareVersion);
        context = this.client.mergeContext(context);
        return this.service.restore(this.client.getEndpoint(), resourceGroupName, accountName, shareName, this.client.getApiVersion(), this.client.getSubscriptionId(), deletedShare, "application/json", context);
    }

    @Override
    public Mono<Void> restoreAsync(String resourceGroupName, String accountName, String shareName, String deletedShareName, String deletedShareVersion) {
        return this.restoreWithResponseAsync(resourceGroupName, accountName, shareName, deletedShareName, deletedShareVersion).flatMap(res -> Mono.empty());
    }

    @Override
    public void restore(String resourceGroupName, String accountName, String shareName, String deletedShareName, String deletedShareVersion) {
        this.restoreAsync(resourceGroupName, accountName, shareName, deletedShareName, deletedShareVersion).block();
    }

    @Override
    public Response<Void> restoreWithResponse(String resourceGroupName, String accountName, String shareName, String deletedShareName, String deletedShareVersion, Context context) {
        return (Response)this.restoreWithResponseAsync(resourceGroupName, accountName, shareName, deletedShareName, deletedShareVersion, context).block();
    }

    private Mono<PagedResponse<FileShareItemInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileShareItems)res.getValue()).value(), ((FileShareItems)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<FileShareItemInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileShareItems)res.getValue()).value(), ((FileShareItems)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageManagementCli")
    private static interface FileSharesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileShareItems>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="$maxpagesize") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="$expand") ListSharesExpand var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileShareInner>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="shareName") String var4, @QueryParam(value="$expand") PutSharesExpand var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") FileShareInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileShareInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="shareName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") FileShareInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileShareInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="shareName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="$expand") GetShareExpand var7, @HeaderParam(value="x-ms-snapshot") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="shareName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="x-ms-snapshot") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> restore(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="shareName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") DeletedShare var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FileShareItems>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

