/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storage.fluent.EncryptionScopesClient;
import com.azure.resourcemanager.storage.fluent.models.EncryptionScopeInner;
import com.azure.resourcemanager.storage.implementation.StorageManagementClientImpl;
import com.azure.resourcemanager.storage.models.EncryptionScopeListResult;
import reactor.core.publisher.Mono;

public final class EncryptionScopesClientImpl
implements EncryptionScopesClient {
    private final ClientLogger logger = new ClientLogger(EncryptionScopesClientImpl.class);
    private final EncryptionScopesService service;
    private final StorageManagementClientImpl client;

    EncryptionScopesClientImpl(StorageManagementClientImpl client) {
        this.service = (EncryptionScopesService)RestProxy.create(EncryptionScopesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<EncryptionScopeInner>> putWithResponseAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (encryptionScopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionScopeName is required and cannot be null."));
        }
        if (encryptionScope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionScope is required and cannot be null."));
        }
        encryptionScope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.put(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), encryptionScopeName, encryptionScope, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<EncryptionScopeInner>> putWithResponseAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (encryptionScopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionScopeName is required and cannot be null."));
        }
        if (encryptionScope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionScope is required and cannot be null."));
        }
        encryptionScope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.put(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), encryptionScopeName, encryptionScope, "application/json", context);
    }

    @Override
    public Mono<EncryptionScopeInner> putAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        return this.putWithResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((EncryptionScopeInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public EncryptionScopeInner put(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        return (EncryptionScopeInner)((Object)this.putAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope).block());
    }

    @Override
    public Response<EncryptionScopeInner> putWithResponse(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope, Context context) {
        return (Response)this.putWithResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope, context).block();
    }

    @Override
    public Mono<Response<EncryptionScopeInner>> patchWithResponseAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (encryptionScopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionScopeName is required and cannot be null."));
        }
        if (encryptionScope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionScope is required and cannot be null."));
        }
        encryptionScope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.patch(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), encryptionScopeName, encryptionScope, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<EncryptionScopeInner>> patchWithResponseAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (encryptionScopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionScopeName is required and cannot be null."));
        }
        if (encryptionScope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionScope is required and cannot be null."));
        }
        encryptionScope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.patch(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), encryptionScopeName, encryptionScope, "application/json", context);
    }

    @Override
    public Mono<EncryptionScopeInner> patchAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        return this.patchWithResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((EncryptionScopeInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public EncryptionScopeInner patch(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        return (EncryptionScopeInner)((Object)this.patchAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope).block());
    }

    @Override
    public Response<EncryptionScopeInner> patchWithResponse(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope, Context context) {
        return (Response)this.patchWithResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope, context).block();
    }

    @Override
    public Mono<Response<EncryptionScopeInner>> getWithResponseAsync(String resourceGroupName, String accountName, String encryptionScopeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (encryptionScopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionScopeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), encryptionScopeName, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<EncryptionScopeInner>> getWithResponseAsync(String resourceGroupName, String accountName, String encryptionScopeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (encryptionScopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionScopeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), encryptionScopeName, "application/json", context);
    }

    @Override
    public Mono<EncryptionScopeInner> getAsync(String resourceGroupName, String accountName, String encryptionScopeName) {
        return this.getWithResponseAsync(resourceGroupName, accountName, encryptionScopeName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((EncryptionScopeInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public EncryptionScopeInner get(String resourceGroupName, String accountName, String encryptionScopeName) {
        return (EncryptionScopeInner)((Object)this.getAsync(resourceGroupName, accountName, encryptionScopeName).block());
    }

    @Override
    public Response<EncryptionScopeInner> getWithResponse(String resourceGroupName, String accountName, String encryptionScopeName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, accountName, encryptionScopeName, context).block();
    }

    private Mono<PagedResponse<EncryptionScopeInner>> listSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EncryptionScopeListResult)res.getValue()).value(), ((EncryptionScopeListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<EncryptionScopeInner>> listSinglePageAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EncryptionScopeListResult)res.getValue()).value(), ((EncryptionScopeListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<EncryptionScopeInner> listAsync(String resourceGroupName, String accountName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<EncryptionScopeInner> listAsync(String resourceGroupName, String accountName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<EncryptionScopeInner> list(String resourceGroupName, String accountName) {
        return new PagedIterable(this.listAsync(resourceGroupName, accountName));
    }

    @Override
    public PagedIterable<EncryptionScopeInner> list(String resourceGroupName, String accountName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, accountName, context));
    }

    private Mono<PagedResponse<EncryptionScopeInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EncryptionScopeListResult)res.getValue()).value(), ((EncryptionScopeListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<EncryptionScopeInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EncryptionScopeListResult)res.getValue()).value(), ((EncryptionScopeListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageManagementCli")
    private static interface EncryptionScopesService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes/{encryptionScopeName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EncryptionScopeInner>> put(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="encryptionScopeName") String var6, @BodyParam(value="application/json") EncryptionScopeInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes/{encryptionScopeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EncryptionScopeInner>> patch(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="encryptionScopeName") String var6, @BodyParam(value="application/json") EncryptionScopeInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes/{encryptionScopeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EncryptionScopeInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="encryptionScopeName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EncryptionScopeListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EncryptionScopeListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

