/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.fluent.models.BlobRestoreStatusInner;
import com.azure.resourcemanager.storage.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.storage.models.AccessTier;
import com.azure.resourcemanager.storage.models.AccountStatus;
import com.azure.resourcemanager.storage.models.AzureFilesIdentityBasedAuthentication;
import com.azure.resourcemanager.storage.models.CustomDomain;
import com.azure.resourcemanager.storage.models.Encryption;
import com.azure.resourcemanager.storage.models.Endpoints;
import com.azure.resourcemanager.storage.models.ExtendedLocation;
import com.azure.resourcemanager.storage.models.GeoReplicationStats;
import com.azure.resourcemanager.storage.models.Identity;
import com.azure.resourcemanager.storage.models.Kind;
import com.azure.resourcemanager.storage.models.LargeFileSharesState;
import com.azure.resourcemanager.storage.models.MinimumTlsVersion;
import com.azure.resourcemanager.storage.models.NetworkRuleSet;
import com.azure.resourcemanager.storage.models.ProvisioningState;
import com.azure.resourcemanager.storage.models.RoutingPreference;
import com.azure.resourcemanager.storage.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class StorageAccountInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(StorageAccountInner.class);
    @JsonProperty(value="sku", access=JsonProperty.Access.WRITE_ONLY)
    private Sku sku;
    @JsonProperty(value="kind", access=JsonProperty.Access.WRITE_ONLY)
    private Kind kind;
    @JsonProperty(value="identity")
    private Identity identity;
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.primaryEndpoints", access=JsonProperty.Access.WRITE_ONLY)
    private Endpoints primaryEndpoints;
    @JsonProperty(value="properties.primaryLocation", access=JsonProperty.Access.WRITE_ONLY)
    private String primaryLocation;
    @JsonProperty(value="properties.statusOfPrimary", access=JsonProperty.Access.WRITE_ONLY)
    private AccountStatus statusOfPrimary;
    @JsonProperty(value="properties.lastGeoFailoverTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastGeoFailoverTime;
    @JsonProperty(value="properties.secondaryLocation", access=JsonProperty.Access.WRITE_ONLY)
    private String secondaryLocation;
    @JsonProperty(value="properties.statusOfSecondary", access=JsonProperty.Access.WRITE_ONLY)
    private AccountStatus statusOfSecondary;
    @JsonProperty(value="properties.creationTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationTime;
    @JsonProperty(value="properties.customDomain", access=JsonProperty.Access.WRITE_ONLY)
    private CustomDomain customDomain;
    @JsonProperty(value="properties.secondaryEndpoints", access=JsonProperty.Access.WRITE_ONLY)
    private Endpoints secondaryEndpoints;
    @JsonProperty(value="properties.encryption", access=JsonProperty.Access.WRITE_ONLY)
    private Encryption encryption;
    @JsonProperty(value="properties.accessTier", access=JsonProperty.Access.WRITE_ONLY)
    private AccessTier accessTier;
    @JsonProperty(value="properties.azureFilesIdentityBasedAuthentication")
    private AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication;
    @JsonProperty(value="properties.supportsHttpsTrafficOnly")
    private Boolean enableHttpsTrafficOnly;
    @JsonProperty(value="properties.networkAcls", access=JsonProperty.Access.WRITE_ONLY)
    private NetworkRuleSet networkRuleSet;
    @JsonProperty(value="properties.isHnsEnabled")
    private Boolean isHnsEnabled;
    @JsonProperty(value="properties.geoReplicationStats", access=JsonProperty.Access.WRITE_ONLY)
    private GeoReplicationStats geoReplicationStats;
    @JsonProperty(value="properties.failoverInProgress", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean failoverInProgress;
    @JsonProperty(value="properties.largeFileSharesState")
    private LargeFileSharesState largeFileSharesState;
    @JsonProperty(value="properties.privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    @JsonProperty(value="properties.routingPreference")
    private RoutingPreference routingPreference;
    @JsonProperty(value="properties.blobRestoreStatus", access=JsonProperty.Access.WRITE_ONLY)
    private BlobRestoreStatusInner blobRestoreStatus;
    @JsonProperty(value="properties.allowBlobPublicAccess")
    private Boolean allowBlobPublicAccess;
    @JsonProperty(value="properties.minimumTlsVersion")
    private MinimumTlsVersion minimumTlsVersion;
    @JsonProperty(value="properties.allowSharedKeyAccess")
    private Boolean allowSharedKeyAccess;
    @JsonProperty(value="properties.isNfsV3Enabled")
    private Boolean enableNfsV3;

    public Sku sku() {
        return this.sku;
    }

    public Kind kind() {
        return this.kind;
    }

    public Identity identity() {
        return this.identity;
    }

    public StorageAccountInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public StorageAccountInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Endpoints primaryEndpoints() {
        return this.primaryEndpoints;
    }

    public String primaryLocation() {
        return this.primaryLocation;
    }

    public AccountStatus statusOfPrimary() {
        return this.statusOfPrimary;
    }

    public OffsetDateTime lastGeoFailoverTime() {
        return this.lastGeoFailoverTime;
    }

    public String secondaryLocation() {
        return this.secondaryLocation;
    }

    public AccountStatus statusOfSecondary() {
        return this.statusOfSecondary;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public CustomDomain customDomain() {
        return this.customDomain;
    }

    public Endpoints secondaryEndpoints() {
        return this.secondaryEndpoints;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public AccessTier accessTier() {
        return this.accessTier;
    }

    public AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication() {
        return this.azureFilesIdentityBasedAuthentication;
    }

    public StorageAccountInner withAzureFilesIdentityBasedAuthentication(AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication) {
        this.azureFilesIdentityBasedAuthentication = azureFilesIdentityBasedAuthentication;
        return this;
    }

    public Boolean enableHttpsTrafficOnly() {
        return this.enableHttpsTrafficOnly;
    }

    public StorageAccountInner withEnableHttpsTrafficOnly(Boolean enableHttpsTrafficOnly) {
        this.enableHttpsTrafficOnly = enableHttpsTrafficOnly;
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public Boolean isHnsEnabled() {
        return this.isHnsEnabled;
    }

    public StorageAccountInner withIsHnsEnabled(Boolean isHnsEnabled) {
        this.isHnsEnabled = isHnsEnabled;
        return this;
    }

    public GeoReplicationStats geoReplicationStats() {
        return this.geoReplicationStats;
    }

    public Boolean failoverInProgress() {
        return this.failoverInProgress;
    }

    public LargeFileSharesState largeFileSharesState() {
        return this.largeFileSharesState;
    }

    public StorageAccountInner withLargeFileSharesState(LargeFileSharesState largeFileSharesState) {
        this.largeFileSharesState = largeFileSharesState;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public RoutingPreference routingPreference() {
        return this.routingPreference;
    }

    public StorageAccountInner withRoutingPreference(RoutingPreference routingPreference) {
        this.routingPreference = routingPreference;
        return this;
    }

    public BlobRestoreStatusInner blobRestoreStatus() {
        return this.blobRestoreStatus;
    }

    public Boolean allowBlobPublicAccess() {
        return this.allowBlobPublicAccess;
    }

    public StorageAccountInner withAllowBlobPublicAccess(Boolean allowBlobPublicAccess) {
        this.allowBlobPublicAccess = allowBlobPublicAccess;
        return this;
    }

    public MinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public StorageAccountInner withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public Boolean allowSharedKeyAccess() {
        return this.allowSharedKeyAccess;
    }

    public StorageAccountInner withAllowSharedKeyAccess(Boolean allowSharedKeyAccess) {
        this.allowSharedKeyAccess = allowSharedKeyAccess;
        return this;
    }

    public Boolean enableNfsV3() {
        return this.enableNfsV3;
    }

    public StorageAccountInner withEnableNfsV3(Boolean enableNfsV3) {
        this.enableNfsV3 = enableNfsV3;
        return this;
    }

    public StorageAccountInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public StorageAccountInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.primaryEndpoints() != null) {
            this.primaryEndpoints().validate();
        }
        if (this.customDomain() != null) {
            this.customDomain().validate();
        }
        if (this.secondaryEndpoints() != null) {
            this.secondaryEndpoints().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.azureFilesIdentityBasedAuthentication() != null) {
            this.azureFilesIdentityBasedAuthentication().validate();
        }
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.geoReplicationStats() != null) {
            this.geoReplicationStats().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.routingPreference() != null) {
            this.routingPreference().validate();
        }
        if (this.blobRestoreStatus() != null) {
            this.blobRestoreStatus().validate();
        }
    }
}

