/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.ObjectReplicationPolicyRule;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

@JsonFlatten
public class ObjectReplicationPolicyInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ObjectReplicationPolicyInner.class);
    @JsonProperty(value="properties.policyId", access=JsonProperty.Access.WRITE_ONLY)
    private String policyId;
    @JsonProperty(value="properties.enabledTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime enabledTime;
    @JsonProperty(value="properties.sourceAccount")
    private String sourceAccount;
    @JsonProperty(value="properties.destinationAccount")
    private String destinationAccount;
    @JsonProperty(value="properties.rules")
    private List<ObjectReplicationPolicyRule> rules;

    public String policyId() {
        return this.policyId;
    }

    public OffsetDateTime enabledTime() {
        return this.enabledTime;
    }

    public String sourceAccount() {
        return this.sourceAccount;
    }

    public ObjectReplicationPolicyInner withSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
        return this;
    }

    public String destinationAccount() {
        return this.destinationAccount;
    }

    public ObjectReplicationPolicyInner withDestinationAccount(String destinationAccount) {
        this.destinationAccount = destinationAccount;
        return this;
    }

    public List<ObjectReplicationPolicyRule> rules() {
        return this.rules;
    }

    public ObjectReplicationPolicyInner withRules(List<ObjectReplicationPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }
}

