// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The SshPublicKey model. */
@Fluent
public final class SshPublicKey {
    /*
     * Optional. It is used to store the function/usage of the key
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Ssh public key base64 encoded. The format should be: '<keyType>
     * <keyData>', e.g. ssh-rsa AAAABBBB
     */
    @JsonProperty(value = "key")
    private String key;

    /**
     * Get the description property: Optional. It is used to store the function/usage of the key.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Optional. It is used to store the function/usage of the key.
     *
     * @param description the description value to set.
     * @return the SshPublicKey object itself.
     */
    public SshPublicKey withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the key property: Ssh public key base64 encoded. The format should be: '&lt;keyType&gt; &lt;keyData&gt;',
     * e.g. ssh-rsa AAAABBBB.
     *
     * @return the key value.
     */
    public String key() {
        return this.key;
    }

    /**
     * Set the key property: Ssh public key base64 encoded. The format should be: '&lt;keyType&gt; &lt;keyData&gt;',
     * e.g. ssh-rsa AAAABBBB.
     *
     * @param key the key value to set.
     * @return the SshPublicKey object itself.
     */
    public SshPublicKey withKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
