// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.storage.fluent.models.BlobInventoryPolicyInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List of blob inventory policies returned. */
@Immutable
public final class ListBlobInventoryPolicy {
    /*
     * List of blob inventory policies.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<BlobInventoryPolicyInner> value;

    /**
     * Get the value property: List of blob inventory policies.
     *
     * @return the value value.
     */
    public List<BlobInventoryPolicyInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
