// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for DnsEndpointType. */
public final class DnsEndpointType extends ExpandableStringEnum<DnsEndpointType> {
    /** Static value Standard for DnsEndpointType. */
    public static final DnsEndpointType STANDARD = fromString("Standard");

    /** Static value AzureDnsZone for DnsEndpointType. */
    public static final DnsEndpointType AZURE_DNS_ZONE = fromString("AzureDnsZone");

    /**
     * Creates or finds a DnsEndpointType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DnsEndpointType.
     */
    @JsonCreator
    public static DnsEndpointType fromString(String name) {
        return fromString(name, DnsEndpointType.class);
    }

    /**
     * Gets known DnsEndpointType values.
     *
     * @return known DnsEndpointType values.
     */
    public static Collection<DnsEndpointType> values() {
        return values(DnsEndpointType.class);
    }
}
