/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyState;
import com.azure.resourcemanager.storage.models.UpdateHistoryProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ImmutabilityPolicyProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ImmutabilityPolicyProperties.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="updateHistory", access=JsonProperty.Access.WRITE_ONLY)
    private List<UpdateHistoryProperty> updateHistory;
    @JsonProperty(value="properties.immutabilityPeriodSinceCreationInDays")
    private Integer immutabilityPeriodSinceCreationInDays;
    @JsonProperty(value="properties.state", access=JsonProperty.Access.WRITE_ONLY)
    private ImmutabilityPolicyState state;
    @JsonProperty(value="properties.allowProtectedAppendWrites")
    private Boolean allowProtectedAppendWrites;

    public String etag() {
        return this.etag;
    }

    public List<UpdateHistoryProperty> updateHistory() {
        return this.updateHistory;
    }

    public Integer immutabilityPeriodSinceCreationInDays() {
        return this.immutabilityPeriodSinceCreationInDays;
    }

    public ImmutabilityPolicyProperties withImmutabilityPeriodSinceCreationInDays(Integer immutabilityPeriodSinceCreationInDays) {
        this.immutabilityPeriodSinceCreationInDays = immutabilityPeriodSinceCreationInDays;
        return this;
    }

    public ImmutabilityPolicyState state() {
        return this.state;
    }

    public Boolean allowProtectedAppendWrites() {
        return this.allowProtectedAppendWrites;
    }

    public ImmutabilityPolicyProperties withAllowProtectedAppendWrites(Boolean allowProtectedAppendWrites) {
        this.allowProtectedAppendWrites = allowProtectedAppendWrites;
        return this;
    }

    public void validate() {
        if (this.updateHistory() != null) {
            this.updateHistory().forEach(e -> e.validate());
        }
    }
}

