/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.CorsRules;
import com.azure.resourcemanager.storage.models.DeleteRetentionPolicy;
import com.azure.resourcemanager.storage.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class FileServicePropertiesInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(FileServicePropertiesInner.class);
    @JsonProperty(value="sku", access=JsonProperty.Access.WRITE_ONLY)
    private Sku sku;
    @JsonProperty(value="properties.cors")
    private CorsRules cors;
    @JsonProperty(value="properties.shareDeleteRetentionPolicy")
    private DeleteRetentionPolicy shareDeleteRetentionPolicy;

    public Sku sku() {
        return this.sku;
    }

    public CorsRules cors() {
        return this.cors;
    }

    public FileServicePropertiesInner withCors(CorsRules cors) {
        this.cors = cors;
        return this;
    }

    public DeleteRetentionPolicy shareDeleteRetentionPolicy() {
        return this.shareDeleteRetentionPolicy;
    }

    public FileServicePropertiesInner withShareDeleteRetentionPolicy(DeleteRetentionPolicy shareDeleteRetentionPolicy) {
        this.shareDeleteRetentionPolicy = shareDeleteRetentionPolicy;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.cors() != null) {
            this.cors().validate();
        }
        if (this.shareDeleteRetentionPolicy() != null) {
            this.shareDeleteRetentionPolicy().validate();
        }
    }
}

