/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.EncryptionScopeKeyVaultProperties;
import com.azure.resourcemanager.storage.models.EncryptionScopeSource;
import com.azure.resourcemanager.storage.models.EncryptionScopeState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

@JsonFlatten
public class EncryptionScopeInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EncryptionScopeInner.class);
    @JsonProperty(value="properties.source")
    private EncryptionScopeSource source;
    @JsonProperty(value="properties.state")
    private EncryptionScopeState state;
    @JsonProperty(value="properties.creationTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationTime;
    @JsonProperty(value="properties.lastModifiedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedTime;
    @JsonProperty(value="properties.keyVaultProperties")
    private EncryptionScopeKeyVaultProperties keyVaultProperties;

    public EncryptionScopeSource source() {
        return this.source;
    }

    public EncryptionScopeInner withSource(EncryptionScopeSource source) {
        this.source = source;
        return this;
    }

    public EncryptionScopeState state() {
        return this.state;
    }

    public EncryptionScopeInner withState(EncryptionScopeState state) {
        this.state = state;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public EncryptionScopeKeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public EncryptionScopeInner withKeyVaultProperties(EncryptionScopeKeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
    }
}

