/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BenchmarkReference;
import com.azure.resourcemanager.sql.models.QueryCheck;
import com.azure.resourcemanager.sql.models.RuleSeverity;
import com.azure.resourcemanager.sql.models.RuleType;
import java.io.IOException;
import java.util.List;

public final class VaRule
implements JsonSerializable<VaRule> {
    private String ruleId;
    private RuleSeverity severity;
    private String category;
    private RuleType ruleType;
    private String title;
    private String description;
    private String rationale;
    private QueryCheck queryCheck;
    private List<BenchmarkReference> benchmarkReferences;

    public String ruleId() {
        return this.ruleId;
    }

    public RuleSeverity severity() {
        return this.severity;
    }

    public String category() {
        return this.category;
    }

    public RuleType ruleType() {
        return this.ruleType;
    }

    public String title() {
        return this.title;
    }

    public String description() {
        return this.description;
    }

    public String rationale() {
        return this.rationale;
    }

    public QueryCheck queryCheck() {
        return this.queryCheck;
    }

    public List<BenchmarkReference> benchmarkReferences() {
        return this.benchmarkReferences;
    }

    public void validate() {
        if (this.queryCheck() != null) {
            this.queryCheck().validate();
        }
        if (this.benchmarkReferences() != null) {
            this.benchmarkReferences().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static VaRule fromJson(JsonReader jsonReader) throws IOException {
        return (VaRule)jsonReader.readObject(reader -> {
            VaRule deserializedVaRule = new VaRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleId".equals(fieldName)) {
                    deserializedVaRule.ruleId = reader.getString();
                    continue;
                }
                if ("severity".equals(fieldName)) {
                    deserializedVaRule.severity = RuleSeverity.fromString(reader.getString());
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedVaRule.category = reader.getString();
                    continue;
                }
                if ("ruleType".equals(fieldName)) {
                    deserializedVaRule.ruleType = RuleType.fromString(reader.getString());
                    continue;
                }
                if ("title".equals(fieldName)) {
                    deserializedVaRule.title = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedVaRule.description = reader.getString();
                    continue;
                }
                if ("rationale".equals(fieldName)) {
                    deserializedVaRule.rationale = reader.getString();
                    continue;
                }
                if ("queryCheck".equals(fieldName)) {
                    deserializedVaRule.queryCheck = QueryCheck.fromJson(reader);
                    continue;
                }
                if ("benchmarkReferences".equals(fieldName)) {
                    List benchmarkReferences;
                    deserializedVaRule.benchmarkReferences = benchmarkReferences = reader.readArray(reader1 -> BenchmarkReference.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVaRule;
        });
    }
}

