/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ReplicationLinkUpdateProperties;
import com.azure.resourcemanager.sql.models.ReplicationLinkType;
import java.io.IOException;

public final class ReplicationLinkUpdate
extends ProxyResource {
    private ReplicationLinkUpdateProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ReplicationLinkUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ReplicationLinkType linkType() {
        return this.innerProperties() == null ? null : this.innerProperties().linkType();
    }

    public ReplicationLinkUpdate withLinkType(ReplicationLinkType linkType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReplicationLinkUpdateProperties();
        }
        this.innerProperties().withLinkType(linkType);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ReplicationLinkUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicationLinkUpdate)((Object)jsonReader.readObject(reader -> {
            ReplicationLinkUpdate deserializedReplicationLinkUpdate = new ReplicationLinkUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedReplicationLinkUpdate.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedReplicationLinkUpdate.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedReplicationLinkUpdate.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedReplicationLinkUpdate.innerProperties = ReplicationLinkUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicationLinkUpdate;
        }));
    }
}

