/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.MetricDefinitionInner;
import java.io.IOException;
import java.util.List;

public final class MetricDefinitionListResult
implements JsonSerializable<MetricDefinitionListResult> {
    private List<MetricDefinitionInner> value;
    private static final ClientLogger LOGGER = new ClientLogger(MetricDefinitionListResult.class);

    public List<MetricDefinitionInner> value() {
        return this.value;
    }

    public MetricDefinitionListResult withValue(List<MetricDefinitionInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model MetricDefinitionListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MetricDefinitionListResult fromJson(JsonReader jsonReader) throws IOException {
        return (MetricDefinitionListResult)jsonReader.readObject(reader -> {
            MetricDefinitionListResult deserializedMetricDefinitionListResult = new MetricDefinitionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedMetricDefinitionListResult.value = value = reader.readArray(reader1 -> MetricDefinitionInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricDefinitionListResult;
        });
    }
}

