/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ManagedInstanceDtcTransactionManagerCommunicationSettings;
import java.io.IOException;

public final class ManagedInstanceDtcSecuritySettings
implements JsonSerializable<ManagedInstanceDtcSecuritySettings> {
    private ManagedInstanceDtcTransactionManagerCommunicationSettings transactionManagerCommunicationSettings;
    private Boolean xaTransactionsEnabled;
    private Boolean snaLu6Point2TransactionsEnabled;
    private Integer xaTransactionsDefaultTimeout;
    private Integer xaTransactionsMaximumTimeout;

    public ManagedInstanceDtcTransactionManagerCommunicationSettings transactionManagerCommunicationSettings() {
        return this.transactionManagerCommunicationSettings;
    }

    public ManagedInstanceDtcSecuritySettings withTransactionManagerCommunicationSettings(ManagedInstanceDtcTransactionManagerCommunicationSettings transactionManagerCommunicationSettings) {
        this.transactionManagerCommunicationSettings = transactionManagerCommunicationSettings;
        return this;
    }

    public Boolean xaTransactionsEnabled() {
        return this.xaTransactionsEnabled;
    }

    public ManagedInstanceDtcSecuritySettings withXaTransactionsEnabled(Boolean xaTransactionsEnabled) {
        this.xaTransactionsEnabled = xaTransactionsEnabled;
        return this;
    }

    public Boolean snaLu6Point2TransactionsEnabled() {
        return this.snaLu6Point2TransactionsEnabled;
    }

    public ManagedInstanceDtcSecuritySettings withSnaLu6Point2TransactionsEnabled(Boolean snaLu6Point2TransactionsEnabled) {
        this.snaLu6Point2TransactionsEnabled = snaLu6Point2TransactionsEnabled;
        return this;
    }

    public Integer xaTransactionsDefaultTimeout() {
        return this.xaTransactionsDefaultTimeout;
    }

    public ManagedInstanceDtcSecuritySettings withXaTransactionsDefaultTimeout(Integer xaTransactionsDefaultTimeout) {
        this.xaTransactionsDefaultTimeout = xaTransactionsDefaultTimeout;
        return this;
    }

    public Integer xaTransactionsMaximumTimeout() {
        return this.xaTransactionsMaximumTimeout;
    }

    public ManagedInstanceDtcSecuritySettings withXaTransactionsMaximumTimeout(Integer xaTransactionsMaximumTimeout) {
        this.xaTransactionsMaximumTimeout = xaTransactionsMaximumTimeout;
        return this;
    }

    public void validate() {
        if (this.transactionManagerCommunicationSettings() != null) {
            this.transactionManagerCommunicationSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("transactionManagerCommunicationSettings", (JsonSerializable)this.transactionManagerCommunicationSettings);
        jsonWriter.writeBooleanField("xaTransactionsEnabled", this.xaTransactionsEnabled);
        jsonWriter.writeBooleanField("snaLu6point2TransactionsEnabled", this.snaLu6Point2TransactionsEnabled);
        jsonWriter.writeNumberField("xaTransactionsDefaultTimeout", (Number)this.xaTransactionsDefaultTimeout);
        jsonWriter.writeNumberField("xaTransactionsMaximumTimeout", (Number)this.xaTransactionsMaximumTimeout);
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceDtcSecuritySettings fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedInstanceDtcSecuritySettings)jsonReader.readObject(reader -> {
            ManagedInstanceDtcSecuritySettings deserializedManagedInstanceDtcSecuritySettings = new ManagedInstanceDtcSecuritySettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionManagerCommunicationSettings".equals(fieldName)) {
                    deserializedManagedInstanceDtcSecuritySettings.transactionManagerCommunicationSettings = ManagedInstanceDtcTransactionManagerCommunicationSettings.fromJson(reader);
                    continue;
                }
                if ("xaTransactionsEnabled".equals(fieldName)) {
                    deserializedManagedInstanceDtcSecuritySettings.xaTransactionsEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("snaLu6point2TransactionsEnabled".equals(fieldName)) {
                    deserializedManagedInstanceDtcSecuritySettings.snaLu6Point2TransactionsEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("xaTransactionsDefaultTimeout".equals(fieldName)) {
                    deserializedManagedInstanceDtcSecuritySettings.xaTransactionsDefaultTimeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("xaTransactionsMaximumTimeout".equals(fieldName)) {
                    deserializedManagedInstanceDtcSecuritySettings.xaTransactionsMaximumTimeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceDtcSecuritySettings;
        });
    }
}

