/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.InstancePoolProperties;
import com.azure.resourcemanager.sql.models.InstancePoolLicenseType;
import com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class InstancePoolUpdate
implements JsonSerializable<InstancePoolUpdate> {
    private Sku sku;
    private InstancePoolProperties innerProperties;
    private Map<String, String> tags;

    public Sku sku() {
        return this.sku;
    }

    public InstancePoolUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private InstancePoolProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public InstancePoolUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    public InstancePoolUpdate withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    public Integer vCores() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().vCores());
    }

    public InstancePoolUpdate withVCores(Integer vCores) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withVCores(vCores);
        return this;
    }

    public InstancePoolLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public InstancePoolUpdate withLicenseType(InstancePoolLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public String dnsZone() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZone();
    }

    public String maintenanceConfigurationId() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceConfigurationId();
    }

    public InstancePoolUpdate withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withMaintenanceConfigurationId(maintenanceConfigurationId);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static InstancePoolUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (InstancePoolUpdate)jsonReader.readObject(reader -> {
            InstancePoolUpdate deserializedInstancePoolUpdate = new InstancePoolUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedInstancePoolUpdate.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedInstancePoolUpdate.innerProperties = InstancePoolProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedInstancePoolUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstancePoolUpdate;
        });
    }
}

