/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CertificateInfo;
import com.azure.resourcemanager.sql.models.ReplicaConnectedState;
import com.azure.resourcemanager.sql.models.ReplicaSynchronizationHealth;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.UUID;

public final class DistributedAvailabilityGroupDatabase
implements JsonSerializable<DistributedAvailabilityGroupDatabase> {
    private String databaseName;
    private UUID instanceReplicaId;
    private UUID partnerReplicaId;
    private String replicaState;
    private String seedingProgress;
    private ReplicaSynchronizationHealth synchronizationHealth;
    private ReplicaConnectedState connectedState;
    private String lastReceivedLsn;
    private OffsetDateTime lastReceivedTime;
    private String lastSentLsn;
    private OffsetDateTime lastSentTime;
    private String lastCommitLsn;
    private OffsetDateTime lastCommitTime;
    private String lastHardenedLsn;
    private OffsetDateTime lastHardenedTime;
    private String lastBackupLsn;
    private OffsetDateTime lastBackupTime;
    private String mostRecentLinkError;
    private CertificateInfo partnerAuthCertValidity;
    private Integer instanceSendReplicationLagSeconds;
    private Integer instanceRedoReplicationLagSeconds;

    public String databaseName() {
        return this.databaseName;
    }

    public DistributedAvailabilityGroupDatabase withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public UUID instanceReplicaId() {
        return this.instanceReplicaId;
    }

    public UUID partnerReplicaId() {
        return this.partnerReplicaId;
    }

    public String replicaState() {
        return this.replicaState;
    }

    public String seedingProgress() {
        return this.seedingProgress;
    }

    public ReplicaSynchronizationHealth synchronizationHealth() {
        return this.synchronizationHealth;
    }

    public ReplicaConnectedState connectedState() {
        return this.connectedState;
    }

    public String lastReceivedLsn() {
        return this.lastReceivedLsn;
    }

    public OffsetDateTime lastReceivedTime() {
        return this.lastReceivedTime;
    }

    public String lastSentLsn() {
        return this.lastSentLsn;
    }

    public OffsetDateTime lastSentTime() {
        return this.lastSentTime;
    }

    public String lastCommitLsn() {
        return this.lastCommitLsn;
    }

    public OffsetDateTime lastCommitTime() {
        return this.lastCommitTime;
    }

    public String lastHardenedLsn() {
        return this.lastHardenedLsn;
    }

    public OffsetDateTime lastHardenedTime() {
        return this.lastHardenedTime;
    }

    public String lastBackupLsn() {
        return this.lastBackupLsn;
    }

    public OffsetDateTime lastBackupTime() {
        return this.lastBackupTime;
    }

    public String mostRecentLinkError() {
        return this.mostRecentLinkError;
    }

    public CertificateInfo partnerAuthCertValidity() {
        return this.partnerAuthCertValidity;
    }

    public Integer instanceSendReplicationLagSeconds() {
        return this.instanceSendReplicationLagSeconds;
    }

    public Integer instanceRedoReplicationLagSeconds() {
        return this.instanceRedoReplicationLagSeconds;
    }

    public void validate() {
        if (this.partnerAuthCertValidity() != null) {
            this.partnerAuthCertValidity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseName", this.databaseName);
        return jsonWriter.writeEndObject();
    }

    public static DistributedAvailabilityGroupDatabase fromJson(JsonReader jsonReader) throws IOException {
        return (DistributedAvailabilityGroupDatabase)jsonReader.readObject(reader -> {
            DistributedAvailabilityGroupDatabase deserializedDistributedAvailabilityGroupDatabase = new DistributedAvailabilityGroupDatabase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseName".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.databaseName = reader.getString();
                    continue;
                }
                if ("instanceReplicaId".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.instanceReplicaId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("partnerReplicaId".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.partnerReplicaId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("replicaState".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.replicaState = reader.getString();
                    continue;
                }
                if ("seedingProgress".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.seedingProgress = reader.getString();
                    continue;
                }
                if ("synchronizationHealth".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.synchronizationHealth = ReplicaSynchronizationHealth.fromString(reader.getString());
                    continue;
                }
                if ("connectedState".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.connectedState = ReplicaConnectedState.fromString(reader.getString());
                    continue;
                }
                if ("lastReceivedLsn".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.lastReceivedLsn = reader.getString();
                    continue;
                }
                if ("lastReceivedTime".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.lastReceivedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastSentLsn".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.lastSentLsn = reader.getString();
                    continue;
                }
                if ("lastSentTime".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.lastSentTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastCommitLsn".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.lastCommitLsn = reader.getString();
                    continue;
                }
                if ("lastCommitTime".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.lastCommitTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastHardenedLsn".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.lastHardenedLsn = reader.getString();
                    continue;
                }
                if ("lastHardenedTime".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.lastHardenedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastBackupLsn".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.lastBackupLsn = reader.getString();
                    continue;
                }
                if ("lastBackupTime".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.lastBackupTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("mostRecentLinkError".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.mostRecentLinkError = reader.getString();
                    continue;
                }
                if ("partnerAuthCertValidity".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.partnerAuthCertValidity = CertificateInfo.fromJson(reader);
                    continue;
                }
                if ("instanceSendReplicationLagSeconds".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.instanceSendReplicationLagSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("instanceRedoReplicationLagSeconds".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupDatabase.instanceRedoReplicationLagSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDistributedAvailabilityGroupDatabase;
        });
    }
}

