/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.DatabaseExtensionsProperties;
import com.azure.resourcemanager.sql.models.OperationMode;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import java.io.IOException;

public final class DatabaseExtensions
extends ProxyResource {
    private DatabaseExtensionsProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private DatabaseExtensionsProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public OperationMode operationMode() {
        return this.innerProperties() == null ? null : this.innerProperties().operationMode();
    }

    public DatabaseExtensions withOperationMode(OperationMode operationMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withOperationMode(operationMode);
        return this;
    }

    public StorageKeyType storageKeyType() {
        return this.innerProperties() == null ? null : this.innerProperties().storageKeyType();
    }

    public DatabaseExtensions withStorageKeyType(StorageKeyType storageKeyType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withStorageKeyType(storageKeyType);
        return this;
    }

    public String storageKey() {
        return this.innerProperties() == null ? null : this.innerProperties().storageKey();
    }

    public DatabaseExtensions withStorageKey(String storageKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withStorageKey(storageKey);
        return this;
    }

    public String storageUri() {
        return this.innerProperties() == null ? null : this.innerProperties().storageUri();
    }

    public DatabaseExtensions withStorageUri(String storageUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseExtensionsProperties();
        }
        this.innerProperties().withStorageUri(storageUri);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseExtensions fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseExtensions)((Object)jsonReader.readObject(reader -> {
            DatabaseExtensions deserializedDatabaseExtensions = new DatabaseExtensions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDatabaseExtensions.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDatabaseExtensions.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDatabaseExtensions.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDatabaseExtensions.innerProperties = DatabaseExtensionsProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseExtensions;
        }));
    }
}

