/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SqlVulnerabilityAssessmentScanError;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanState;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanTriggerType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class SqlVulnerabilityAssessmentScanRecordProperties
implements JsonSerializable<SqlVulnerabilityAssessmentScanRecordProperties> {
    private String scanId;
    private VulnerabilityAssessmentScanTriggerType triggerType;
    private VulnerabilityAssessmentScanState state;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private List<SqlVulnerabilityAssessmentScanError> errors;
    private String server;
    private String database;
    private String sqlVersion;
    private Integer highSeverityFailedRulesCount;
    private Integer mediumSeverityFailedRulesCount;
    private Integer lowSeverityFailedRulesCount;
    private Integer totalPassedRulesCount;
    private Integer totalFailedRulesCount;
    private Integer totalRulesCount;
    private Boolean isBaselineApplied;
    private OffsetDateTime lastScanTime;

    public String scanId() {
        return this.scanId;
    }

    public VulnerabilityAssessmentScanTriggerType triggerType() {
        return this.triggerType;
    }

    public VulnerabilityAssessmentScanState state() {
        return this.state;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public List<SqlVulnerabilityAssessmentScanError> errors() {
        return this.errors;
    }

    public String server() {
        return this.server;
    }

    public String database() {
        return this.database;
    }

    public String sqlVersion() {
        return this.sqlVersion;
    }

    public Integer highSeverityFailedRulesCount() {
        return this.highSeverityFailedRulesCount;
    }

    public Integer mediumSeverityFailedRulesCount() {
        return this.mediumSeverityFailedRulesCount;
    }

    public Integer lowSeverityFailedRulesCount() {
        return this.lowSeverityFailedRulesCount;
    }

    public Integer totalPassedRulesCount() {
        return this.totalPassedRulesCount;
    }

    public Integer totalFailedRulesCount() {
        return this.totalFailedRulesCount;
    }

    public Integer totalRulesCount() {
        return this.totalRulesCount;
    }

    public Boolean isBaselineApplied() {
        return this.isBaselineApplied;
    }

    public OffsetDateTime lastScanTime() {
        return this.lastScanTime;
    }

    public void validate() {
        if (this.errors() != null) {
            this.errors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SqlVulnerabilityAssessmentScanRecordProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SqlVulnerabilityAssessmentScanRecordProperties)jsonReader.readObject(reader -> {
            SqlVulnerabilityAssessmentScanRecordProperties deserializedSqlVulnerabilityAssessmentScanRecordProperties = new SqlVulnerabilityAssessmentScanRecordProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scanId".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.scanId = reader.getString();
                    continue;
                }
                if ("triggerType".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.triggerType = VulnerabilityAssessmentScanTriggerType.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.state = VulnerabilityAssessmentScanState.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.errors = errors = reader.readArray(reader1 -> SqlVulnerabilityAssessmentScanError.fromJson(reader1));
                    continue;
                }
                if ("server".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.server = reader.getString();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.database = reader.getString();
                    continue;
                }
                if ("sqlVersion".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.sqlVersion = reader.getString();
                    continue;
                }
                if ("highSeverityFailedRulesCount".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.highSeverityFailedRulesCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("mediumSeverityFailedRulesCount".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.mediumSeverityFailedRulesCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("lowSeverityFailedRulesCount".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.lowSeverityFailedRulesCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("totalPassedRulesCount".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.totalPassedRulesCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("totalFailedRulesCount".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.totalFailedRulesCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("totalRulesCount".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.totalRulesCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isBaselineApplied".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.isBaselineApplied = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastScanTime".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanRecordProperties.lastScanTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlVulnerabilityAssessmentScanRecordProperties;
        });
    }
}

