/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ServerCommunicationLinkProperties
implements JsonSerializable<ServerCommunicationLinkProperties> {
    private String state;
    private String partnerServer;
    private static final ClientLogger LOGGER = new ClientLogger(ServerCommunicationLinkProperties.class);

    public String state() {
        return this.state;
    }

    public String partnerServer() {
        return this.partnerServer;
    }

    public ServerCommunicationLinkProperties withPartnerServer(String partnerServer) {
        this.partnerServer = partnerServer;
        return this;
    }

    public void validate() {
        if (this.partnerServer() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property partnerServer in model ServerCommunicationLinkProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("partnerServer", this.partnerServer);
        return jsonWriter.writeEndObject();
    }

    public static ServerCommunicationLinkProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerCommunicationLinkProperties)jsonReader.readObject(reader -> {
            ServerCommunicationLinkProperties deserializedServerCommunicationLinkProperties = new ServerCommunicationLinkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("partnerServer".equals(fieldName)) {
                    deserializedServerCommunicationLinkProperties.partnerServer = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedServerCommunicationLinkProperties.state = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerCommunicationLinkProperties;
        });
    }
}

