/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.MetricName;
import com.azure.resourcemanager.sql.models.MetricValue;
import com.azure.resourcemanager.sql.models.UnitType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class MetricInner
implements JsonSerializable<MetricInner> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String timeGrain;
    private UnitType unit;
    private MetricName name;
    private List<MetricValue> metricValues;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public String timeGrain() {
        return this.timeGrain;
    }

    public UnitType unit() {
        return this.unit;
    }

    public MetricName name() {
        return this.name;
    }

    public List<MetricValue> metricValues() {
        return this.metricValues;
    }

    public void validate() {
        if (this.name() != null) {
            this.name().validate();
        }
        if (this.metricValues() != null) {
            this.metricValues().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MetricInner fromJson(JsonReader jsonReader) throws IOException {
        return (MetricInner)jsonReader.readObject(reader -> {
            MetricInner deserializedMetricInner = new MetricInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedMetricInner.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedMetricInner.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("timeGrain".equals(fieldName)) {
                    deserializedMetricInner.timeGrain = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedMetricInner.unit = UnitType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMetricInner.name = MetricName.fromJson(reader);
                    continue;
                }
                if ("metricValues".equals(fieldName)) {
                    List metricValues;
                    deserializedMetricInner.metricValues = metricValues = reader.readArray(reader1 -> MetricValue.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricInner;
        });
    }
}

