/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ManagedInstanceDtcSecuritySettings;
import com.azure.resourcemanager.sql.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ManagedInstanceDtcProperties
implements JsonSerializable<ManagedInstanceDtcProperties> {
    private Boolean dtcEnabled;
    private ManagedInstanceDtcSecuritySettings securitySettings;
    private List<String> externalDnsSuffixSearchList;
    private String dtcHostnameDnsSuffix;
    private ProvisioningState provisioningState;

    public Boolean dtcEnabled() {
        return this.dtcEnabled;
    }

    public ManagedInstanceDtcProperties withDtcEnabled(Boolean dtcEnabled) {
        this.dtcEnabled = dtcEnabled;
        return this;
    }

    public ManagedInstanceDtcSecuritySettings securitySettings() {
        return this.securitySettings;
    }

    public ManagedInstanceDtcProperties withSecuritySettings(ManagedInstanceDtcSecuritySettings securitySettings) {
        this.securitySettings = securitySettings;
        return this;
    }

    public List<String> externalDnsSuffixSearchList() {
        return this.externalDnsSuffixSearchList;
    }

    public ManagedInstanceDtcProperties withExternalDnsSuffixSearchList(List<String> externalDnsSuffixSearchList) {
        this.externalDnsSuffixSearchList = externalDnsSuffixSearchList;
        return this;
    }

    public String dtcHostnameDnsSuffix() {
        return this.dtcHostnameDnsSuffix;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.securitySettings() != null) {
            this.securitySettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("dtcEnabled", this.dtcEnabled);
        jsonWriter.writeJsonField("securitySettings", (JsonSerializable)this.securitySettings);
        jsonWriter.writeArrayField("externalDnsSuffixSearchList", this.externalDnsSuffixSearchList, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceDtcProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedInstanceDtcProperties)jsonReader.readObject(reader -> {
            ManagedInstanceDtcProperties deserializedManagedInstanceDtcProperties = new ManagedInstanceDtcProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dtcEnabled".equals(fieldName)) {
                    deserializedManagedInstanceDtcProperties.dtcEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("securitySettings".equals(fieldName)) {
                    deserializedManagedInstanceDtcProperties.securitySettings = ManagedInstanceDtcSecuritySettings.fromJson(reader);
                    continue;
                }
                if ("externalDnsSuffixSearchList".equals(fieldName)) {
                    List externalDnsSuffixSearchList;
                    deserializedManagedInstanceDtcProperties.externalDnsSuffixSearchList = externalDnsSuffixSearchList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("dtcHostNameDnsSuffix".equals(fieldName)) {
                    deserializedManagedInstanceDtcProperties.dtcHostnameDnsSuffix = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedInstanceDtcProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceDtcProperties;
        });
    }
}

