/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ManagedInstanceDtcProperties;
import com.azure.resourcemanager.sql.models.ManagedInstanceDtcSecuritySettings;
import com.azure.resourcemanager.sql.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ManagedInstanceDtcInner
extends ProxyResource {
    private ManagedInstanceDtcProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ManagedInstanceDtcProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Boolean dtcEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().dtcEnabled();
    }

    public ManagedInstanceDtcInner withDtcEnabled(Boolean dtcEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceDtcProperties();
        }
        this.innerProperties().withDtcEnabled(dtcEnabled);
        return this;
    }

    public ManagedInstanceDtcSecuritySettings securitySettings() {
        return this.innerProperties() == null ? null : this.innerProperties().securitySettings();
    }

    public ManagedInstanceDtcInner withSecuritySettings(ManagedInstanceDtcSecuritySettings securitySettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceDtcProperties();
        }
        this.innerProperties().withSecuritySettings(securitySettings);
        return this;
    }

    public List<String> externalDnsSuffixSearchList() {
        return this.innerProperties() == null ? null : this.innerProperties().externalDnsSuffixSearchList();
    }

    public ManagedInstanceDtcInner withExternalDnsSuffixSearchList(List<String> externalDnsSuffixSearchList) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceDtcProperties();
        }
        this.innerProperties().withExternalDnsSuffixSearchList(externalDnsSuffixSearchList);
        return this;
    }

    public String dtcHostnameDnsSuffix() {
        return this.innerProperties() == null ? null : this.innerProperties().dtcHostnameDnsSuffix();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceDtcInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedInstanceDtcInner)((Object)jsonReader.readObject(reader -> {
            ManagedInstanceDtcInner deserializedManagedInstanceDtcInner = new ManagedInstanceDtcInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedInstanceDtcInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedInstanceDtcInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedInstanceDtcInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedInstanceDtcInner.innerProperties = ManagedInstanceDtcProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceDtcInner;
        }));
    }
}

