/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ManagementOperationState;
import com.azure.resourcemanager.sql.models.MoveOperationMode;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ManagedDatabaseMoveOperationResultProperties
implements JsonSerializable<ManagedDatabaseMoveOperationResultProperties> {
    private String operation;
    private String operationFriendlyName;
    private OffsetDateTime startTime;
    private ManagementOperationState state;
    private MoveOperationMode operationMode;
    private String sourceManagedInstanceName;
    private String targetManagedInstanceName;
    private String sourceManagedInstanceId;
    private String targetManagedInstanceId;
    private String sourceDatabaseName;
    private String targetDatabaseName;
    private Boolean isCancellable;
    private Integer errorCode;
    private String errorDescription;
    private Integer errorSeverity;
    private Boolean isUserError;

    public String operation() {
        return this.operation;
    }

    public String operationFriendlyName() {
        return this.operationFriendlyName;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ManagementOperationState state() {
        return this.state;
    }

    public MoveOperationMode operationMode() {
        return this.operationMode;
    }

    public String sourceManagedInstanceName() {
        return this.sourceManagedInstanceName;
    }

    public String targetManagedInstanceName() {
        return this.targetManagedInstanceName;
    }

    public String sourceManagedInstanceId() {
        return this.sourceManagedInstanceId;
    }

    public String targetManagedInstanceId() {
        return this.targetManagedInstanceId;
    }

    public String sourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    public String targetDatabaseName() {
        return this.targetDatabaseName;
    }

    public Boolean isCancellable() {
        return this.isCancellable;
    }

    public Integer errorCode() {
        return this.errorCode;
    }

    public String errorDescription() {
        return this.errorDescription;
    }

    public Integer errorSeverity() {
        return this.errorSeverity;
    }

    public Boolean isUserError() {
        return this.isUserError;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ManagedDatabaseMoveOperationResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedDatabaseMoveOperationResultProperties)jsonReader.readObject(reader -> {
            ManagedDatabaseMoveOperationResultProperties deserializedManagedDatabaseMoveOperationResultProperties = new ManagedDatabaseMoveOperationResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operation".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.operation = reader.getString();
                    continue;
                }
                if ("operationFriendlyName".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.operationFriendlyName = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.state = ManagementOperationState.fromString(reader.getString());
                    continue;
                }
                if ("operationMode".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.operationMode = MoveOperationMode.fromString(reader.getString());
                    continue;
                }
                if ("sourceManagedInstanceName".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.sourceManagedInstanceName = reader.getString();
                    continue;
                }
                if ("targetManagedInstanceName".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.targetManagedInstanceName = reader.getString();
                    continue;
                }
                if ("sourceManagedInstanceId".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.sourceManagedInstanceId = reader.getString();
                    continue;
                }
                if ("targetManagedInstanceId".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.targetManagedInstanceId = reader.getString();
                    continue;
                }
                if ("sourceDatabaseName".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.sourceDatabaseName = reader.getString();
                    continue;
                }
                if ("targetDatabaseName".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.targetDatabaseName = reader.getString();
                    continue;
                }
                if ("isCancellable".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.isCancellable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.errorCode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("errorDescription".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.errorDescription = reader.getString();
                    continue;
                }
                if ("errorSeverity".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.errorSeverity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isUserError".equals(fieldName)) {
                    deserializedManagedDatabaseMoveOperationResultProperties.isUserError = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedDatabaseMoveOperationResultProperties;
        });
    }
}

