/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.JobPrivateEndpointProperties;
import java.io.IOException;

public final class JobPrivateEndpointInner
extends ProxyResource {
    private JobPrivateEndpointProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private JobPrivateEndpointProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String targetServerAzureResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetServerAzureResourceId();
    }

    public JobPrivateEndpointInner withTargetServerAzureResourceId(String targetServerAzureResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobPrivateEndpointProperties();
        }
        this.innerProperties().withTargetServerAzureResourceId(targetServerAzureResourceId);
        return this;
    }

    public String privateEndpointId() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointId();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static JobPrivateEndpointInner fromJson(JsonReader jsonReader) throws IOException {
        return (JobPrivateEndpointInner)((Object)jsonReader.readObject(reader -> {
            JobPrivateEndpointInner deserializedJobPrivateEndpointInner = new JobPrivateEndpointInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedJobPrivateEndpointInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedJobPrivateEndpointInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobPrivateEndpointInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedJobPrivateEndpointInner.innerProperties = JobPrivateEndpointProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobPrivateEndpointInner;
        }));
    }
}

