/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.GeoBackupPolicyProperties;
import com.azure.resourcemanager.sql.models.GeoBackupPolicyState;
import java.io.IOException;

public final class GeoBackupPolicyInner
extends ProxyResource {
    private GeoBackupPolicyProperties innerProperties = new GeoBackupPolicyProperties();
    private String kind;
    private String location;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(GeoBackupPolicyInner.class);

    private GeoBackupPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public String kind() {
        return this.kind;
    }

    public String location() {
        return this.location;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public GeoBackupPolicyState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public GeoBackupPolicyInner withState(GeoBackupPolicyState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GeoBackupPolicyProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public String storageType() {
        return this.innerProperties() == null ? null : this.innerProperties().storageType();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model GeoBackupPolicyInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static GeoBackupPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (GeoBackupPolicyInner)((Object)jsonReader.readObject(reader -> {
            GeoBackupPolicyInner deserializedGeoBackupPolicyInner = new GeoBackupPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGeoBackupPolicyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGeoBackupPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGeoBackupPolicyInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGeoBackupPolicyInner.innerProperties = GeoBackupPolicyProperties.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedGeoBackupPolicyInner.kind = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedGeoBackupPolicyInner.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGeoBackupPolicyInner;
        }));
    }
}

