/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.AlwaysEncryptedEnclaveType;
import com.azure.resourcemanager.sql.models.AvailabilityZoneType;
import com.azure.resourcemanager.sql.models.ElasticPoolLicenseType;
import com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseSettings;
import com.azure.resourcemanager.sql.models.ElasticPoolState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ElasticPoolProperties
implements JsonSerializable<ElasticPoolProperties> {
    private ElasticPoolState state;
    private OffsetDateTime creationDate;
    private Long maxSizeBytes;
    private Double minCapacity;
    private ElasticPoolPerDatabaseSettings perDatabaseSettings;
    private Boolean zoneRedundant;
    private ElasticPoolLicenseType licenseType;
    private String maintenanceConfigurationId;
    private Integer highAvailabilityReplicaCount;
    private AlwaysEncryptedEnclaveType preferredEnclaveType;
    private AvailabilityZoneType availabilityZone;

    public ElasticPoolState state() {
        return this.state;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public ElasticPoolProperties withMaxSizeBytes(Long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public Double minCapacity() {
        return this.minCapacity;
    }

    public ElasticPoolProperties withMinCapacity(Double minCapacity) {
        this.minCapacity = minCapacity;
        return this;
    }

    public ElasticPoolPerDatabaseSettings perDatabaseSettings() {
        return this.perDatabaseSettings;
    }

    public ElasticPoolProperties withPerDatabaseSettings(ElasticPoolPerDatabaseSettings perDatabaseSettings) {
        this.perDatabaseSettings = perDatabaseSettings;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public ElasticPoolProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public ElasticPoolLicenseType licenseType() {
        return this.licenseType;
    }

    public ElasticPoolProperties withLicenseType(ElasticPoolLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public String maintenanceConfigurationId() {
        return this.maintenanceConfigurationId;
    }

    public ElasticPoolProperties withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        this.maintenanceConfigurationId = maintenanceConfigurationId;
        return this;
    }

    public Integer highAvailabilityReplicaCount() {
        return this.highAvailabilityReplicaCount;
    }

    public ElasticPoolProperties withHighAvailabilityReplicaCount(Integer highAvailabilityReplicaCount) {
        this.highAvailabilityReplicaCount = highAvailabilityReplicaCount;
        return this;
    }

    public AlwaysEncryptedEnclaveType preferredEnclaveType() {
        return this.preferredEnclaveType;
    }

    public ElasticPoolProperties withPreferredEnclaveType(AlwaysEncryptedEnclaveType preferredEnclaveType) {
        this.preferredEnclaveType = preferredEnclaveType;
        return this;
    }

    public AvailabilityZoneType availabilityZone() {
        return this.availabilityZone;
    }

    public ElasticPoolProperties withAvailabilityZone(AvailabilityZoneType availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public void validate() {
        if (this.perDatabaseSettings() != null) {
            this.perDatabaseSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxSizeBytes", (Number)this.maxSizeBytes);
        jsonWriter.writeNumberField("minCapacity", (Number)this.minCapacity);
        jsonWriter.writeJsonField("perDatabaseSettings", (JsonSerializable)this.perDatabaseSettings);
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        jsonWriter.writeStringField("maintenanceConfigurationId", this.maintenanceConfigurationId);
        jsonWriter.writeNumberField("highAvailabilityReplicaCount", (Number)this.highAvailabilityReplicaCount);
        jsonWriter.writeStringField("preferredEnclaveType", this.preferredEnclaveType == null ? null : this.preferredEnclaveType.toString());
        jsonWriter.writeStringField("availabilityZone", this.availabilityZone == null ? null : this.availabilityZone.toString());
        return jsonWriter.writeEndObject();
    }

    public static ElasticPoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticPoolProperties)jsonReader.readObject(reader -> {
            ElasticPoolProperties deserializedElasticPoolProperties = new ElasticPoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedElasticPoolProperties.state = ElasticPoolState.fromString(reader.getString());
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedElasticPoolProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("maxSizeBytes".equals(fieldName)) {
                    deserializedElasticPoolProperties.maxSizeBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("minCapacity".equals(fieldName)) {
                    deserializedElasticPoolProperties.minCapacity = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("perDatabaseSettings".equals(fieldName)) {
                    deserializedElasticPoolProperties.perDatabaseSettings = ElasticPoolPerDatabaseSettings.fromJson(reader);
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedElasticPoolProperties.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedElasticPoolProperties.licenseType = ElasticPoolLicenseType.fromString(reader.getString());
                    continue;
                }
                if ("maintenanceConfigurationId".equals(fieldName)) {
                    deserializedElasticPoolProperties.maintenanceConfigurationId = reader.getString();
                    continue;
                }
                if ("highAvailabilityReplicaCount".equals(fieldName)) {
                    deserializedElasticPoolProperties.highAvailabilityReplicaCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("preferredEnclaveType".equals(fieldName)) {
                    deserializedElasticPoolProperties.preferredEnclaveType = AlwaysEncryptedEnclaveType.fromString(reader.getString());
                    continue;
                }
                if ("availabilityZone".equals(fieldName)) {
                    deserializedElasticPoolProperties.availabilityZone = AvailabilityZoneType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticPoolProperties;
        });
    }
}

