/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.JobExecutionLifecycle;
import com.azure.resourcemanager.sql.models.JobExecutionTarget;
import com.azure.resourcemanager.sql.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.UUID;

public final class JobExecutionProperties
implements JsonSerializable<JobExecutionProperties> {
    private Integer jobVersion;
    private String stepName;
    private Integer stepId;
    private UUID jobExecutionId;
    private JobExecutionLifecycle lifecycle;
    private ProvisioningState provisioningState;
    private OffsetDateTime createTime;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Integer currentAttempts;
    private OffsetDateTime currentAttemptStartTime;
    private String lastMessage;
    private JobExecutionTarget target;

    public Integer jobVersion() {
        return this.jobVersion;
    }

    public String stepName() {
        return this.stepName;
    }

    public Integer stepId() {
        return this.stepId;
    }

    public UUID jobExecutionId() {
        return this.jobExecutionId;
    }

    public JobExecutionLifecycle lifecycle() {
        return this.lifecycle;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime createTime() {
        return this.createTime;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public Integer currentAttempts() {
        return this.currentAttempts;
    }

    public JobExecutionProperties withCurrentAttempts(Integer currentAttempts) {
        this.currentAttempts = currentAttempts;
        return this;
    }

    public OffsetDateTime currentAttemptStartTime() {
        return this.currentAttemptStartTime;
    }

    public String lastMessage() {
        return this.lastMessage;
    }

    public JobExecutionTarget target() {
        return this.target;
    }

    public void validate() {
        if (this.target() != null) {
            this.target().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("currentAttempts", (Number)this.currentAttempts);
        return jsonWriter.writeEndObject();
    }

    public static JobExecutionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobExecutionProperties)jsonReader.readObject(reader -> {
            JobExecutionProperties deserializedJobExecutionProperties = new JobExecutionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobVersion".equals(fieldName)) {
                    deserializedJobExecutionProperties.jobVersion = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("stepName".equals(fieldName)) {
                    deserializedJobExecutionProperties.stepName = reader.getString();
                    continue;
                }
                if ("stepId".equals(fieldName)) {
                    deserializedJobExecutionProperties.stepId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("jobExecutionId".equals(fieldName)) {
                    deserializedJobExecutionProperties.jobExecutionId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("lifecycle".equals(fieldName)) {
                    deserializedJobExecutionProperties.lifecycle = JobExecutionLifecycle.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedJobExecutionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedJobExecutionProperties.createTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedJobExecutionProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedJobExecutionProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("currentAttempts".equals(fieldName)) {
                    deserializedJobExecutionProperties.currentAttempts = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("currentAttemptStartTime".equals(fieldName)) {
                    deserializedJobExecutionProperties.currentAttemptStartTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastMessage".equals(fieldName)) {
                    deserializedJobExecutionProperties.lastMessage = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedJobExecutionProperties.target = JobExecutionTarget.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobExecutionProperties;
        });
    }
}

