/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.TableTemporalType;
import java.io.IOException;

public final class DatabaseTableProperties
implements JsonSerializable<DatabaseTableProperties> {
    private TableTemporalType temporalType;
    private Boolean memoryOptimized;

    public TableTemporalType temporalType() {
        return this.temporalType;
    }

    public DatabaseTableProperties withTemporalType(TableTemporalType temporalType) {
        this.temporalType = temporalType;
        return this;
    }

    public Boolean memoryOptimized() {
        return this.memoryOptimized;
    }

    public DatabaseTableProperties withMemoryOptimized(Boolean memoryOptimized) {
        this.memoryOptimized = memoryOptimized;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("temporalType", this.temporalType == null ? null : this.temporalType.toString());
        jsonWriter.writeBooleanField("memoryOptimized", this.memoryOptimized);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseTableProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseTableProperties)jsonReader.readObject(reader -> {
            DatabaseTableProperties deserializedDatabaseTableProperties = new DatabaseTableProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("temporalType".equals(fieldName)) {
                    deserializedDatabaseTableProperties.temporalType = TableTemporalType.fromString(reader.getString());
                    continue;
                }
                if ("memoryOptimized".equals(fieldName)) {
                    deserializedDatabaseTableProperties.memoryOptimized = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseTableProperties;
        });
    }
}

