/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class WorkloadClassifierProperties
implements JsonSerializable<WorkloadClassifierProperties> {
    private String memberName;
    private String label;
    private String context;
    private String startTime;
    private String endTime;
    private String importance;
    private static final ClientLogger LOGGER = new ClientLogger(WorkloadClassifierProperties.class);

    public String memberName() {
        return this.memberName;
    }

    public WorkloadClassifierProperties withMemberName(String memberName) {
        this.memberName = memberName;
        return this;
    }

    public String label() {
        return this.label;
    }

    public WorkloadClassifierProperties withLabel(String label) {
        this.label = label;
        return this;
    }

    public String context() {
        return this.context;
    }

    public WorkloadClassifierProperties withContext(String context) {
        this.context = context;
        return this;
    }

    public String startTime() {
        return this.startTime;
    }

    public WorkloadClassifierProperties withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String endTime() {
        return this.endTime;
    }

    public WorkloadClassifierProperties withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public String importance() {
        return this.importance;
    }

    public WorkloadClassifierProperties withImportance(String importance) {
        this.importance = importance;
        return this;
    }

    public void validate() {
        if (this.memberName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property memberName in model WorkloadClassifierProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("memberName", this.memberName);
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeStringField("context", this.context);
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeStringField("endTime", this.endTime);
        jsonWriter.writeStringField("importance", this.importance);
        return jsonWriter.writeEndObject();
    }

    public static WorkloadClassifierProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WorkloadClassifierProperties)jsonReader.readObject(reader -> {
            WorkloadClassifierProperties deserializedWorkloadClassifierProperties = new WorkloadClassifierProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("memberName".equals(fieldName)) {
                    deserializedWorkloadClassifierProperties.memberName = reader.getString();
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedWorkloadClassifierProperties.label = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    deserializedWorkloadClassifierProperties.context = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedWorkloadClassifierProperties.startTime = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedWorkloadClassifierProperties.endTime = reader.getString();
                    continue;
                }
                if ("importance".equals(fieldName)) {
                    deserializedWorkloadClassifierProperties.importance = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkloadClassifierProperties;
        });
    }
}

