/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.InstancePoolProperties;
import com.azure.resourcemanager.sql.models.InstancePoolLicenseType;
import com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class InstancePoolInner
extends Resource {
    private Sku sku;
    private InstancePoolProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public Sku sku() {
        return this.sku;
    }

    public InstancePoolInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private InstancePoolProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public InstancePoolInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public InstancePoolInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    public InstancePoolInner withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    public Integer vCores() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().vCores());
    }

    public InstancePoolInner withVCores(Integer vCores) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withVCores(vCores);
        return this;
    }

    public InstancePoolLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public InstancePoolInner withLicenseType(InstancePoolLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static InstancePoolInner fromJson(JsonReader jsonReader) throws IOException {
        return (InstancePoolInner)((Object)jsonReader.readObject(reader -> {
            InstancePoolInner deserializedInstancePoolInner = new InstancePoolInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedInstancePoolInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedInstancePoolInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedInstancePoolInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedInstancePoolInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedInstancePoolInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedInstancePoolInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedInstancePoolInner.innerProperties = InstancePoolProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstancePoolInner;
        }));
    }
}

