/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.AutomaticTuningMode;
import com.azure.resourcemanager.sql.models.AutomaticTuningOptions;
import java.io.IOException;
import java.util.Map;

public final class DatabaseAutomaticTuningProperties
implements JsonSerializable<DatabaseAutomaticTuningProperties> {
    private AutomaticTuningMode desiredState;
    private AutomaticTuningMode actualState;
    private Map<String, AutomaticTuningOptions> options;

    public AutomaticTuningMode desiredState() {
        return this.desiredState;
    }

    public DatabaseAutomaticTuningProperties withDesiredState(AutomaticTuningMode desiredState) {
        this.desiredState = desiredState;
        return this;
    }

    public AutomaticTuningMode actualState() {
        return this.actualState;
    }

    public Map<String, AutomaticTuningOptions> options() {
        return this.options;
    }

    public DatabaseAutomaticTuningProperties withOptions(Map<String, AutomaticTuningOptions> options) {
        this.options = options;
        return this;
    }

    public void validate() {
        if (this.options() != null) {
            this.options().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("desiredState", this.desiredState == null ? null : this.desiredState.toString());
        jsonWriter.writeMapField("options", this.options, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DatabaseAutomaticTuningProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseAutomaticTuningProperties)jsonReader.readObject(reader -> {
            DatabaseAutomaticTuningProperties deserializedDatabaseAutomaticTuningProperties = new DatabaseAutomaticTuningProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("desiredState".equals(fieldName)) {
                    deserializedDatabaseAutomaticTuningProperties.desiredState = AutomaticTuningMode.fromString(reader.getString());
                    continue;
                }
                if ("actualState".equals(fieldName)) {
                    deserializedDatabaseAutomaticTuningProperties.actualState = AutomaticTuningMode.fromString(reader.getString());
                    continue;
                }
                if ("options".equals(fieldName)) {
                    Map options;
                    deserializedDatabaseAutomaticTuningProperties.options = options = reader.readMap(reader1 -> AutomaticTuningOptions.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseAutomaticTuningProperties;
        });
    }
}

