/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ManagedDatabaseProperties;
import com.azure.resourcemanager.sql.models.CatalogCollationType;
import com.azure.resourcemanager.sql.models.ManagedDatabaseCreateMode;
import com.azure.resourcemanager.sql.models.ManagedDatabaseStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ManagedDatabaseInner
extends Resource {
    private ManagedDatabaseProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ManagedDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ManagedDatabaseInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ManagedDatabaseInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String collation() {
        return this.innerProperties() == null ? null : this.innerProperties().collation();
    }

    public ManagedDatabaseInner withCollation(String collation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withCollation(collation);
        return this;
    }

    public ManagedDatabaseStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public OffsetDateTime earliestRestorePoint() {
        return this.innerProperties() == null ? null : this.innerProperties().earliestRestorePoint();
    }

    public OffsetDateTime restorePointInTime() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointInTime();
    }

    public ManagedDatabaseInner withRestorePointInTime(OffsetDateTime restorePointInTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withRestorePointInTime(restorePointInTime);
        return this;
    }

    public String defaultSecondaryLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultSecondaryLocation();
    }

    public CatalogCollationType catalogCollation() {
        return this.innerProperties() == null ? null : this.innerProperties().catalogCollation();
    }

    public ManagedDatabaseInner withCatalogCollation(CatalogCollationType catalogCollation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withCatalogCollation(catalogCollation);
        return this;
    }

    public ManagedDatabaseCreateMode createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    public ManagedDatabaseInner withCreateMode(ManagedDatabaseCreateMode createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    public String storageContainerUri() {
        return this.innerProperties() == null ? null : this.innerProperties().storageContainerUri();
    }

    public ManagedDatabaseInner withStorageContainerUri(String storageContainerUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withStorageContainerUri(storageContainerUri);
        return this;
    }

    public String sourceDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDatabaseId();
    }

    public ManagedDatabaseInner withSourceDatabaseId(String sourceDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withSourceDatabaseId(sourceDatabaseId);
        return this;
    }

    public String restorableDroppedDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().restorableDroppedDatabaseId();
    }

    public ManagedDatabaseInner withRestorableDroppedDatabaseId(String restorableDroppedDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withRestorableDroppedDatabaseId(restorableDroppedDatabaseId);
        return this;
    }

    public String storageContainerSasToken() {
        return this.innerProperties() == null ? null : this.innerProperties().storageContainerSasToken();
    }

    public ManagedDatabaseInner withStorageContainerSasToken(String storageContainerSasToken) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withStorageContainerSasToken(storageContainerSasToken);
        return this;
    }

    public String failoverGroupId() {
        return this.innerProperties() == null ? null : this.innerProperties().failoverGroupId();
    }

    public String recoverableDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().recoverableDatabaseId();
    }

    public ManagedDatabaseInner withRecoverableDatabaseId(String recoverableDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withRecoverableDatabaseId(recoverableDatabaseId);
        return this;
    }

    public String longTermRetentionBackupResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().longTermRetentionBackupResourceId();
    }

    public ManagedDatabaseInner withLongTermRetentionBackupResourceId(String longTermRetentionBackupResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withLongTermRetentionBackupResourceId(longTermRetentionBackupResourceId);
        return this;
    }

    public Boolean autoCompleteRestore() {
        return this.innerProperties() == null ? null : this.innerProperties().autoCompleteRestore();
    }

    public ManagedDatabaseInner withAutoCompleteRestore(Boolean autoCompleteRestore) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withAutoCompleteRestore(autoCompleteRestore);
        return this;
    }

    public String lastBackupName() {
        return this.innerProperties() == null ? null : this.innerProperties().lastBackupName();
    }

    public ManagedDatabaseInner withLastBackupName(String lastBackupName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedDatabaseProperties();
        }
        this.innerProperties().withLastBackupName(lastBackupName);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedDatabaseInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedDatabaseInner)((Object)jsonReader.readObject(reader -> {
            ManagedDatabaseInner deserializedManagedDatabaseInner = new ManagedDatabaseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedDatabaseInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedDatabaseInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedDatabaseInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedManagedDatabaseInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedDatabaseInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedDatabaseInner.innerProperties = ManagedDatabaseProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedDatabaseInner;
        }));
    }
}

