/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.JobProperties;
import com.azure.resourcemanager.sql.models.JobSchedule;
import java.io.IOException;

public final class JobInner
extends ProxyResource {
    private JobProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private JobProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public JobInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Integer version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public JobSchedule schedule() {
        return this.innerProperties() == null ? null : this.innerProperties().schedule();
    }

    public JobInner withSchedule(JobSchedule schedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobProperties();
        }
        this.innerProperties().withSchedule(schedule);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static JobInner fromJson(JsonReader jsonReader) throws IOException {
        return (JobInner)((Object)jsonReader.readObject(reader -> {
            JobInner deserializedJobInner = new JobInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedJobInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedJobInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedJobInner.innerProperties = JobProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobInner;
        }));
    }
}

