/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.JobStepsClient;
import com.azure.resourcemanager.sql.fluent.models.JobStepInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.JobStepListResult;
import reactor.core.publisher.Mono;

public final class JobStepsClientImpl
implements JobStepsClient {
    private final ClientLogger logger = new ClientLogger(JobStepsClientImpl.class);
    private final JobStepsService service;
    private final SqlManagementClientImpl client;

    JobStepsClientImpl(SqlManagementClientImpl client) {
        this.service = (JobStepsService)RestProxy.create(JobStepsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<JobStepInner>> listByVersionSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.listByVersion(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobVersion, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStepListResult)res.getValue()).value(), ((JobStepListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<JobStepInner>> listByVersionSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listByVersion(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobVersion, this.client.getSubscriptionId(), "2017-03-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStepListResult)res.getValue()).value(), ((JobStepListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<JobStepInner> listByVersionAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion) {
        return new PagedFlux(() -> this.listByVersionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion), nextLink -> this.listByVersionNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<JobStepInner> listByVersionAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, Context context) {
        return new PagedFlux(() -> this.listByVersionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion, context), nextLink -> this.listByVersionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<JobStepInner> listByVersion(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion) {
        return new PagedIterable(this.listByVersionAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion));
    }

    @Override
    public PagedIterable<JobStepInner> listByVersion(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, Context context) {
        return new PagedIterable(this.listByVersionAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion, context));
    }

    @Override
    public Mono<Response<JobStepInner>> getByVersionWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, String stepName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (stepName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter stepName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.getByVersion(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobVersion, stepName, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<JobStepInner>> getByVersionWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, String stepName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (stepName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter stepName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.getByVersion(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobVersion, stepName, this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    public Mono<JobStepInner> getByVersionAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, String stepName) {
        return this.getByVersionWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion, stepName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((JobStepInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public JobStepInner getByVersion(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, String stepName) {
        return (JobStepInner)((Object)this.getByVersionAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion, stepName).block());
    }

    @Override
    public Response<JobStepInner> getByVersionWithResponse(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, String stepName, Context context) {
        return (Response)this.getByVersionWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion, stepName, context).block();
    }

    private Mono<PagedResponse<JobStepInner>> listByJobSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.listByJob(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStepListResult)res.getValue()).value(), ((JobStepListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<JobStepInner>> listByJobSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listByJob(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, this.client.getSubscriptionId(), "2017-03-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStepListResult)res.getValue()).value(), ((JobStepListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<JobStepInner> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return new PagedFlux(() -> this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName), nextLink -> this.listByJobNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<JobStepInner> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        return new PagedFlux(() -> this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, context), nextLink -> this.listByJobNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<JobStepInner> listByJob(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return new PagedIterable(this.listByJobAsync(resourceGroupName, serverName, jobAgentName, jobName));
    }

    @Override
    public PagedIterable<JobStepInner> listByJob(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        return new PagedIterable(this.listByJobAsync(resourceGroupName, serverName, jobAgentName, jobName, context));
    }

    @Override
    public Mono<Response<JobStepInner>> getWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (stepName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter stepName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, stepName, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<JobStepInner>> getWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (stepName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter stepName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, stepName, this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    public Mono<JobStepInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((JobStepInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public JobStepInner get(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName) {
        return (JobStepInner)((Object)this.getAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName).block());
    }

    @Override
    public Response<JobStepInner> getWithResponse(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName, context).block();
    }

    @Override
    public Mono<Response<JobStepInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, JobStepInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (stepName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter stepName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, stepName, this.client.getSubscriptionId(), "2017-03-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<JobStepInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, JobStepInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (stepName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter stepName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, stepName, this.client.getSubscriptionId(), "2017-03-01-preview", parameters, context);
    }

    @Override
    public Mono<JobStepInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, JobStepInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((JobStepInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public JobStepInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, JobStepInner parameters) {
        return (JobStepInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName, parameters).block());
    }

    @Override
    public Response<JobStepInner> createOrUpdateWithResponse(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, JobStepInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName, parameters, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (stepName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter stepName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, stepName, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (stepName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter stepName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, stepName, this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName) {
        return this.deleteWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName) {
        this.deleteAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName, context).block();
    }

    private Mono<PagedResponse<JobStepInner>> listByVersionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByVersionNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStepListResult)res.getValue()).value(), ((JobStepListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<JobStepInner>> listByVersionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByVersionNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStepListResult)res.getValue()).value(), ((JobStepListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<JobStepInner>> listByJobNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByJobNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStepListResult)res.getValue()).value(), ((JobStepListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<JobStepInner>> listByJobNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByJobNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStepListResult)res.getValue()).value(), ((JobStepListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientJ")
    private static interface JobStepsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/versions/{jobVersion}/steps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStepListResult>> listByVersion(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="jobVersion") int var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/versions/{jobVersion}/steps/{stepName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStepInner>> getByVersion(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="jobVersion") int var6, @PathParam(value="stepName") String var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, Context var10);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStepListResult>> listByJob(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps/{stepName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStepInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="stepName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps/{stepName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStepInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="stepName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") JobStepInner var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps/{stepName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="stepName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStepListResult>> listByVersionNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStepListResult>> listByJobNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

