/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.ServerPrivateEndpointConnection;
import com.azure.resourcemanager.sql.models.ServerPublicNetworkAccess;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class ServerUpdate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServerUpdate.class);
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="properties.administratorLogin")
    private String administratorLogin;
    @JsonProperty(value="properties.administratorLoginPassword")
    private String administratorLoginPassword;
    @JsonProperty(value="properties.version")
    private String version;
    @JsonProperty(value="properties.state", access=JsonProperty.Access.WRITE_ONLY)
    private String state;
    @JsonProperty(value="properties.fullyQualifiedDomainName", access=JsonProperty.Access.WRITE_ONLY)
    private String fullyQualifiedDomainName;
    @JsonProperty(value="properties.privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<ServerPrivateEndpointConnection> privateEndpointConnections;
    @JsonProperty(value="properties.minimalTlsVersion")
    private String minimalTlsVersion;
    @JsonProperty(value="properties.publicNetworkAccess")
    private ServerPublicNetworkAccess publicNetworkAccess;

    public Map<String, String> tags() {
        return this.tags;
    }

    public ServerUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ServerUpdate withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ServerUpdate withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ServerUpdate withVersion(String version) {
        this.version = version;
        return this;
    }

    public String state() {
        return this.state;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public String minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public ServerUpdate withMinimalTlsVersion(String minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public ServerPublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ServerUpdate withPublicNetworkAccess(ServerPublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }
}

