/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.search.fluent.SharedPrivateLinkResourcesClient;
import com.azure.resourcemanager.search.fluent.models.SharedPrivateLinkResourceInner;
import com.azure.resourcemanager.search.implementation.SearchManagementClientImpl;
import com.azure.resourcemanager.search.models.SharedPrivateLinkResourceListResult;
import com.azure.resourcemanager.search.models.SharedPrivateLinkResourceProperties;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SharedPrivateLinkResourcesClientImpl
implements SharedPrivateLinkResourcesClient {
    private final ClientLogger logger = new ClientLogger(SharedPrivateLinkResourcesClientImpl.class);
    private final SharedPrivateLinkResourcesService service;
    private final SearchManagementClientImpl client;

    SharedPrivateLinkResourcesClientImpl(SearchManagementClientImpl client) {
        this.service = (SharedPrivateLinkResourcesService)RestProxy.create(SharedPrivateLinkResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, SharedPrivateLinkResourceProperties properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (sharedPrivateLinkResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sharedPrivateLinkResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        String accept = "application/json";
        SharedPrivateLinkResourceInner sharedPrivateLinkResource = new SharedPrivateLinkResourceInner();
        sharedPrivateLinkResource.withProperties(properties);
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), sharedPrivateLinkResource, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, SharedPrivateLinkResourceProperties properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (sharedPrivateLinkResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sharedPrivateLinkResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        String accept = "application/json";
        SharedPrivateLinkResourceInner sharedPrivateLinkResource = new SharedPrivateLinkResourceInner();
        sharedPrivateLinkResource.withProperties(properties);
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), sharedPrivateLinkResource, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<SharedPrivateLinkResourceInner>, SharedPrivateLinkResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, SharedPrivateLinkResourceProperties properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SharedPrivateLinkResourceInner.class), (Type)((Object)SharedPrivateLinkResourceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<SharedPrivateLinkResourceInner>, SharedPrivateLinkResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, SharedPrivateLinkResourceProperties properties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SharedPrivateLinkResourceInner.class), (Type)((Object)SharedPrivateLinkResourceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<SharedPrivateLinkResourceInner>, SharedPrivateLinkResourceInner> beginCreateOrUpdate(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, SharedPrivateLinkResourceProperties properties) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<SharedPrivateLinkResourceInner>, SharedPrivateLinkResourceInner> beginCreateOrUpdate(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, SharedPrivateLinkResourceProperties properties, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties, context).getSyncPoller();
    }

    @Override
    public Mono<SharedPrivateLinkResourceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, SharedPrivateLinkResourceProperties properties) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties).last().flatMap(arg_0 -> ((SearchManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<SharedPrivateLinkResourceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName) {
        UUID clientRequestId = null;
        SharedPrivateLinkResourceProperties properties = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties).last().flatMap(arg_0 -> ((SearchManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<SharedPrivateLinkResourceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, SharedPrivateLinkResourceProperties properties, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties, context).last().flatMap(arg_0 -> ((SearchManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public SharedPrivateLinkResourceInner createOrUpdate(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, SharedPrivateLinkResourceProperties properties) {
        return (SharedPrivateLinkResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties).block());
    }

    @Override
    public SharedPrivateLinkResourceInner createOrUpdate(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName) {
        UUID clientRequestId = null;
        SharedPrivateLinkResourceProperties properties = null;
        return (SharedPrivateLinkResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties).block());
    }

    @Override
    public SharedPrivateLinkResourceInner createOrUpdate(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, SharedPrivateLinkResourceProperties properties, Context context) {
        return (SharedPrivateLinkResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties, context).block());
    }

    @Override
    public Mono<Response<SharedPrivateLinkResourceInner>> getWithResponseAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (sharedPrivateLinkResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sharedPrivateLinkResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SharedPrivateLinkResourceInner>> getWithResponseAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (sharedPrivateLinkResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sharedPrivateLinkResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    public Mono<SharedPrivateLinkResourceInner> getAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId) {
        return this.getWithResponseAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SharedPrivateLinkResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<SharedPrivateLinkResourceInner> getAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName) {
        UUID clientRequestId = null;
        return this.getWithResponseAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SharedPrivateLinkResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SharedPrivateLinkResourceInner get(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName) {
        UUID clientRequestId = null;
        return (SharedPrivateLinkResourceInner)((Object)this.getAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId).block());
    }

    @Override
    public Response<SharedPrivateLinkResourceInner> getWithResponse(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (sharedPrivateLinkResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sharedPrivateLinkResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (sharedPrivateLinkResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sharedPrivateLinkResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId) {
        return this.beginDeleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, Context context) {
        return this.beginDeleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId) {
        return this.beginDeleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId).last().flatMap(arg_0 -> ((SearchManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName) {
        UUID clientRequestId = null;
        return this.beginDeleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId).last().flatMap(arg_0 -> ((SearchManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, Context context) {
        return this.beginDeleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, context).last().flatMap(arg_0 -> ((SearchManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId) {
        this.deleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId).block();
    }

    @Override
    public void delete(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName) {
        UUID clientRequestId = null;
        this.deleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId).block();
    }

    @Override
    public void delete(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName, UUID clientRequestId, Context context) {
        this.deleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, context).block();
    }

    private Mono<PagedResponse<SharedPrivateLinkResourceInner>> listByServiceSinglePageAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByService(this.client.getEndpoint(), clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, searchServiceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedPrivateLinkResourceListResult)res.getValue()).value(), ((SharedPrivateLinkResourceListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SharedPrivateLinkResourceInner>> listByServiceSinglePageAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByService(this.client.getEndpoint(), clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, searchServiceName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedPrivateLinkResourceListResult)res.getValue()).value(), ((SharedPrivateLinkResourceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<SharedPrivateLinkResourceInner> listByServiceAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, searchServiceName, clientRequestId), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink, clientRequestId));
    }

    @Override
    public PagedFlux<SharedPrivateLinkResourceInner> listByServiceAsync(String resourceGroupName, String searchServiceName) {
        UUID clientRequestId = null;
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, searchServiceName, clientRequestId), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink, clientRequestId));
    }

    private PagedFlux<SharedPrivateLinkResourceInner> listByServiceAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        return new PagedFlux(() -> this.listByServiceSinglePageAsync(resourceGroupName, searchServiceName, clientRequestId, context), nextLink -> this.listByServiceNextSinglePageAsync((String)nextLink, clientRequestId, context));
    }

    @Override
    public PagedIterable<SharedPrivateLinkResourceInner> listByService(String resourceGroupName, String searchServiceName) {
        UUID clientRequestId = null;
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, searchServiceName, clientRequestId));
    }

    @Override
    public PagedIterable<SharedPrivateLinkResourceInner> listByService(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        return new PagedIterable(this.listByServiceAsync(resourceGroupName, searchServiceName, clientRequestId, context));
    }

    private Mono<PagedResponse<SharedPrivateLinkResourceInner>> listByServiceNextSinglePageAsync(String nextLink, UUID clientRequestId) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByServiceNext(nextLink, this.client.getEndpoint(), clientRequestId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedPrivateLinkResourceListResult)res.getValue()).value(), ((SharedPrivateLinkResourceListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SharedPrivateLinkResourceInner>> listByServiceNextSinglePageAsync(String nextLink, UUID clientRequestId, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByServiceNext(nextLink, this.client.getEndpoint(), clientRequestId, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedPrivateLinkResourceListResult)res.getValue()).value(), ((SharedPrivateLinkResourceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SearchManagementClie")
    private static interface SharedPrivateLinkResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/sharedPrivateLinkResources/{sharedPrivateLinkResourceName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @PathParam(value="sharedPrivateLinkResourceName") String var4, @HeaderParam(value="x-ms-client-request-id") UUID var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") SharedPrivateLinkResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/sharedPrivateLinkResources/{sharedPrivateLinkResourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SharedPrivateLinkResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @PathParam(value="sharedPrivateLinkResourceName") String var4, @HeaderParam(value="x-ms-client-request-id") UUID var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/sharedPrivateLinkResources/{sharedPrivateLinkResourceName}")
        @ExpectedResponses(value={202, 204, 404})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @PathParam(value="sharedPrivateLinkResourceName") String var4, @HeaderParam(value="x-ms-client-request-id") UUID var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/sharedPrivateLinkResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SharedPrivateLinkResourceListResult>> listByService(@HostParam(value="$host") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceGroupName") String var5, @PathParam(value="searchServiceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SharedPrivateLinkResourceListResult>> listByServiceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

