/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.search.SearchServiceManager;
import com.azure.resourcemanager.search.fluent.SearchManagementClient;
import com.azure.resourcemanager.search.fluent.models.SearchServiceInner;
import com.azure.resourcemanager.search.implementation.AdminKeysImpl;
import com.azure.resourcemanager.search.implementation.QueryKeyImpl;
import com.azure.resourcemanager.search.implementation.SearchServiceImpl;
import com.azure.resourcemanager.search.models.AdminKeyKind;
import com.azure.resourcemanager.search.models.AdminKeys;
import com.azure.resourcemanager.search.models.CheckNameAvailabilityOutput;
import com.azure.resourcemanager.search.models.QueryKey;
import com.azure.resourcemanager.search.models.SearchService;
import com.azure.resourcemanager.search.models.SearchServices;
import reactor.core.publisher.Mono;

public class SearchServicesImpl
extends GroupableResourcesImpl<SearchService, SearchServiceImpl, SearchServiceInner, SearchManagementClient, SearchServiceManager>
implements SearchServices {
    public SearchServicesImpl(SearchServiceManager searchManager) {
        super((Object)((SearchManagementClient)searchManager.serviceClient()), (Manager)searchManager);
    }

    protected Mono<SearchServiceInner> getInnerAsync(String resourceGroupName, String name) {
        return ((SearchManagementClient)this.inner()).getServices().getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((SearchManagementClient)this.inner()).getServices().deleteAsync(resourceGroupName, name);
    }

    protected SearchServiceImpl wrapModel(String name) {
        SearchServiceInner inner = new SearchServiceInner();
        return new SearchServiceImpl(name, inner, (SearchServiceManager)this.manager());
    }

    protected SearchServiceImpl wrapModel(SearchServiceInner inner) {
        if (inner == null) {
            return null;
        }
        return new SearchServiceImpl(inner.name(), inner, (SearchServiceManager)this.manager());
    }

    @Override
    public CheckNameAvailabilityOutput checkNameAvailability(String name) {
        return (CheckNameAvailabilityOutput)this.checkNameAvailabilityAsync(name).block();
    }

    @Override
    public Mono<CheckNameAvailabilityOutput> checkNameAvailabilityAsync(String name) {
        return ((SearchManagementClient)this.inner()).getServices().checkNameAvailabilityAsync(name);
    }

    @Override
    public AdminKeys getAdminKeys(String resourceGroupName, String searchServiceName) {
        return (AdminKeys)this.getAdminKeysAsync(resourceGroupName, searchServiceName).block();
    }

    @Override
    public Mono<AdminKeys> getAdminKeysAsync(String resourceGroupName, String searchServiceName) {
        return ((SearchManagementClient)this.inner()).getAdminKeys().getAsync(resourceGroupName, searchServiceName).map(AdminKeysImpl::new);
    }

    @Override
    public PagedIterable<QueryKey> listQueryKeys(String resourceGroupName, String searchServiceName) {
        return new PagedIterable(this.listQueryKeysAsync(resourceGroupName, searchServiceName));
    }

    @Override
    public PagedFlux<QueryKey> listQueryKeysAsync(String resourceGroupName, String searchServiceName) {
        return PagedConverter.mapPage(((SearchManagementClient)this.inner()).getQueryKeys().listBySearchServiceAsync(resourceGroupName, searchServiceName), QueryKeyImpl::new);
    }

    @Override
    public AdminKeys regenerateAdminKeys(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        return (AdminKeys)this.regenerateAdminKeysAsync(resourceGroupName, searchServiceName, keyKind).block();
    }

    @Override
    public Mono<AdminKeys> regenerateAdminKeysAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        return ((SearchManagementClient)this.inner()).getAdminKeys().regenerateAsync(resourceGroupName, searchServiceName, keyKind).map(AdminKeysImpl::new);
    }

    @Override
    public QueryKey createQueryKey(String resourceGroupName, String searchServiceName, String name) {
        return (QueryKey)this.createQueryKeyAsync(resourceGroupName, searchServiceName, name).block();
    }

    @Override
    public Mono<QueryKey> createQueryKeyAsync(String resourceGroupName, String searchServiceName, String name) {
        return ((SearchManagementClient)this.inner()).getQueryKeys().createAsync(resourceGroupName, searchServiceName, name).map(QueryKeyImpl::new);
    }

    @Override
    public void deleteQueryKey(String resourceGroupName, String searchServiceName, String key) {
        this.deleteQueryKeyAsync(resourceGroupName, searchServiceName, key).block();
    }

    @Override
    public Mono<Void> deleteQueryKeyAsync(String resourceGroupName, String searchServiceName, String key) {
        return ((SearchManagementClient)this.inner()).getQueryKeys().deleteAsync(resourceGroupName, searchServiceName, key);
    }

    public PagedIterable<SearchService> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    public PagedFlux<SearchService> listByResourceGroupAsync(String resourceGroupName) {
        return PagedConverter.mapPage(((SearchManagementClient)this.inner()).getServices().listByResourceGroupAsync(resourceGroupName), this::wrapModel);
    }

    public SearchServiceImpl define(String name) {
        return this.wrapModel(name);
    }

    public PagedIterable<SearchService> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<SearchService> listAsync() {
        return PagedConverter.mapPage(((SearchManagementClient)this.inner()).getServices().listAsync(), this::wrapModel);
    }
}

