/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluent.ResourceManagementClient;
import com.azure.resourcemanager.resources.fluent.ResourcesClient;
import com.azure.resourcemanager.resources.fluent.models.GenericResourceInner;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.resources.models.GenericResource;
import com.azure.resourcemanager.resources.models.Identity;
import com.azure.resourcemanager.resources.models.Plan;
import com.azure.resourcemanager.resources.models.Provider;
import com.azure.resourcemanager.resources.models.ResourceIdentityType;
import com.azure.resourcemanager.resources.models.Sku;
import reactor.core.publisher.Mono;

final class GenericResourceImpl
extends GroupableResourceImpl<GenericResource, GenericResourceInner, GenericResourceImpl, ResourceManager>
implements GenericResource,
GenericResource.Definition,
GenericResource.UpdateStages.WithApiVersion,
GenericResource.Update {
    private final ClientLogger logger = new ClientLogger(GenericResourceImpl.class);
    private String resourceProviderNamespace;
    private String parentResourcePath;
    private String resourceType;
    private String apiVersion;

    GenericResourceImpl(String key, GenericResourceInner innerModel, ResourceManager resourceManager) {
        super(key, innerModel, resourceManager);
        this.resourceProviderNamespace = ResourceUtils.resourceProviderFromResourceId(innerModel.id());
        this.resourceType = ResourceUtils.resourceTypeFromResourceId(innerModel.id());
        this.parentResourcePath = ResourceUtils.parentRelativePathFromResourceId(innerModel.id());
    }

    @Override
    public String resourceProviderNamespace() {
        return this.resourceProviderNamespace;
    }

    @Override
    public String parentResourcePath() {
        if (this.parentResourcePath == null) {
            return "";
        }
        return this.parentResourcePath;
    }

    @Override
    public String resourceType() {
        return this.resourceType;
    }

    @Override
    public String apiVersion() {
        if (this.apiVersion == null) {
            this.apiVersion = ResourceUtils.defaultApiVersion(this.id(), (Provider)((ResourceManager)this.manager()).providers().getByName(ResourceUtils.resourceProviderFromResourceId(this.id())));
        }
        return this.apiVersion;
    }

    @Override
    public Plan plan() {
        return ((GenericResourceInner)((Object)this.innerModel())).plan();
    }

    @Override
    public Object properties() {
        return ((GenericResourceInner)((Object)this.innerModel())).properties();
    }

    @Override
    public String kind() {
        return ((GenericResourceInner)((Object)this.innerModel())).kind();
    }

    @Override
    public Sku sku() {
        return ((GenericResourceInner)((Object)this.innerModel())).sku();
    }

    @Override
    public Identity identity() {
        return ((GenericResourceInner)((Object)this.innerModel())).identity();
    }

    @Override
    public String managedBy() {
        return ((GenericResourceInner)((Object)this.innerModel())).managedBy();
    }

    @Override
    protected Mono<GenericResourceInner> getInnerAsync() {
        return ((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getResources().getAsync(this.resourceGroupName(), this.resourceProviderNamespace(), this.parentResourcePath(), this.resourceType(), this.name(), this.apiVersion());
    }

    @Override
    public GenericResourceImpl withProperties(Object properties) {
        ((GenericResourceInner)((Object)this.innerModel())).withProperties(properties);
        return this;
    }

    @Override
    public GenericResourceImpl withKind(String kind) {
        ((GenericResourceInner)((Object)this.innerModel())).withKind(kind);
        return this;
    }

    @Override
    public GenericResourceImpl withSku(Sku sku) {
        ((GenericResourceInner)((Object)this.innerModel())).withSku(sku);
        return this;
    }

    @Override
    public GenericResourceImpl withIdentity(Identity identity) {
        ((GenericResourceInner)((Object)this.innerModel())).withIdentity(identity);
        return this;
    }

    @Override
    public GenericResourceImpl withoutIdentity() {
        ((GenericResourceInner)((Object)this.innerModel())).withIdentity(new Identity().withType(ResourceIdentityType.NONE));
        return this;
    }

    @Override
    public GenericResourceImpl withParentResourceId(String parentResourceId) {
        return this.withParentResourcePath(ResourceUtils.relativePathFromResourceId(parentResourceId));
    }

    @Override
    public GenericResourceImpl withParentResourcePath(String parentResourcePath) {
        this.parentResourcePath = parentResourcePath;
        return this;
    }

    @Override
    public GenericResourceImpl withPlan(String name, String publisher, String product, String promotionCode) {
        ((GenericResourceInner)((Object)this.innerModel())).withPlan(new Plan().withName(name).withPublisher(publisher).withProduct(product).withPromotionCode(promotionCode));
        return this;
    }

    @Override
    public GenericResourceImpl withPlan(Plan plan) {
        ((GenericResourceInner)((Object)this.innerModel())).withPlan(plan);
        return this;
    }

    @Override
    public GenericResourceImpl withoutPlan() {
        ((GenericResourceInner)((Object)this.innerModel())).withPlan(null);
        return this;
    }

    @Override
    public GenericResourceImpl withProviderNamespace(String resourceProviderNamespace) {
        this.resourceProviderNamespace = resourceProviderNamespace;
        return this;
    }

    @Override
    public GenericResourceImpl withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Override
    public GenericResourceImpl withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public Accepted<GenericResource> beginCreate() {
        String apiVersion = (String)this.getApiVersionAsync().block();
        String name = this.isInCreateMode() ? this.name() : ResourceUtils.nameFromResourceId(((GenericResourceInner)((Object)this.innerModel())).id());
        return AcceptedImpl.newAccepted(this.logger, ((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getHttpPipeline(), ((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> (Response)((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getResources().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.resourceProviderNamespace, this.parentResourcePath(), this.resourceType, name, apiVersion, (GenericResourceInner)((Object)((Object)this.innerModel()))).block(), inner -> new GenericResourceImpl(inner.id(), (GenericResourceInner)((Object)inner), (ResourceManager)this.manager()), GenericResourceInner.class, null, this::setInner, Context.NONE);
    }

    @Override
    public Mono<GenericResource> createResourceAsync() {
        Mono<String> observable = this.getApiVersionAsync();
        ResourcesClient resourceClient = ((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getResources();
        return observable.flatMap(api -> {
            String name = this.name();
            if (!this.isInCreateMode()) {
                name = ResourceUtils.nameFromResourceId(((GenericResourceInner)((Object)((Object)this.innerModel()))).id());
            }
            return resourceClient.createOrUpdateAsync(this.resourceGroupName(), this.resourceProviderNamespace, this.parentResourcePath(), this.resourceType, name, (String)api, (GenericResourceInner)((Object)((Object)this.innerModel()))).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler()).map(this.innerToFluentMap(this));
        });
    }

    private Mono<String> getApiVersionAsync() {
        Mono apiVersion = this.apiVersion != null ? Mono.just((Object)this.apiVersion) : ((ResourceManager)this.manager()).providers().getByNameAsync(this.resourceProviderNamespace).flatMap(provider -> {
            String id = !this.isInCreateMode() ? ((GenericResourceInner)((Object)((Object)this.innerModel()))).id() : ResourceUtils.constructResourceId(((ResourceManager)this.manager()).subscriptionId(), this.resourceGroupName(), this.resourceProviderNamespace(), this.resourceType(), this.name(), this.parentResourcePath());
            this.apiVersion = ResourceUtils.defaultApiVersion(id, provider);
            return Mono.just((Object)this.apiVersion);
        });
        return apiVersion;
    }
}

