/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DeploymentIdentity;
import com.azure.resourcemanager.resources.models.DeploymentProperties;
import java.io.IOException;
import java.util.Map;

public final class DeploymentInner
implements JsonSerializable<DeploymentInner> {
    private String location;
    private DeploymentProperties properties;
    private Map<String, String> tags;
    private DeploymentIdentity identity;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentInner.class);

    public String location() {
        return this.location;
    }

    public DeploymentInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public DeploymentProperties properties() {
        return this.properties;
    }

    public DeploymentInner withProperties(DeploymentProperties properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DeploymentInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public DeploymentIdentity identity() {
        return this.identity;
    }

    public DeploymentInner withIdentity(DeploymentIdentity identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model DeploymentInner"));
        }
        this.properties().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentInner fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentInner)jsonReader.readObject(reader -> {
            DeploymentInner deserializedDeploymentInner = new DeploymentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedDeploymentInner.properties = DeploymentProperties.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDeploymentInner.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDeploymentInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedDeploymentInner.identity = DeploymentIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentInner;
        });
    }
}

