/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.DataBoundariesClient;
import com.azure.resourcemanager.resources.fluent.DataBoundariesManagementClient;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.azure.resourcemanager.resources.implementation.DataBoundariesClientImpl;
import com.azure.resourcemanager.resources.implementation.DataBoundariesManagementClientBuilder;
import java.time.Duration;

@ServiceClient(builder=DataBoundariesManagementClientBuilder.class)
public final class DataBoundariesManagementClientImpl
extends AzureServiceClient
implements DataBoundariesManagementClient {
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final DataBoundariesClient dataBoundaries;

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public DataBoundariesClient getDataBoundaries() {
        return this.dataBoundaries;
    }

    DataBoundariesManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.endpoint = endpoint;
        this.apiVersion = "2024-08-01";
        this.dataBoundaries = new DataBoundariesClientImpl(this);
    }
}

