/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ResourceGroupProperties;
import java.io.IOException;
import java.util.Map;

public final class ResourceGroupPatchable
implements JsonSerializable<ResourceGroupPatchable> {
    private String name;
    private ResourceGroupProperties properties;
    private String managedBy;
    private Map<String, String> tags;

    public String name() {
        return this.name;
    }

    public ResourceGroupPatchable withName(String name) {
        this.name = name;
        return this;
    }

    public ResourceGroupProperties properties() {
        return this.properties;
    }

    public ResourceGroupPatchable withProperties(ResourceGroupProperties properties) {
        this.properties = properties;
        return this;
    }

    public String managedBy() {
        return this.managedBy;
    }

    public ResourceGroupPatchable withManagedBy(String managedBy) {
        this.managedBy = managedBy;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ResourceGroupPatchable withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeStringField("managedBy", this.managedBy);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceGroupPatchable fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceGroupPatchable)jsonReader.readObject(reader -> {
            ResourceGroupPatchable deserializedResourceGroupPatchable = new ResourceGroupPatchable();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedResourceGroupPatchable.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedResourceGroupPatchable.properties = ResourceGroupProperties.fromJson(reader);
                    continue;
                }
                if ("managedBy".equals(fieldName)) {
                    deserializedResourceGroupPatchable.managedBy = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedResourceGroupPatchable.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceGroupPatchable;
        });
    }
}

